/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kinesisfirehose.model.OrcSerDe;
import java.util.List;

@SdkInternalApi
public class OrcSerDeMarshaller {
    private static final MarshallingInfo<Integer> STRIPESIZEBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StripeSizeBytes").build();
    private static final MarshallingInfo<Integer> BLOCKSIZEBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BlockSizeBytes").build();
    private static final MarshallingInfo<Integer> ROWINDEXSTRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RowIndexStride").build();
    private static final MarshallingInfo<Boolean> ENABLEPADDING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnablePadding").build();
    private static final MarshallingInfo<Double> PADDINGTOLERANCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PaddingTolerance").build();
    private static final MarshallingInfo<String> COMPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Compression").build();
    private static final MarshallingInfo<List> BLOOMFILTERCOLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BloomFilterColumns").build();
    private static final MarshallingInfo<Double> BLOOMFILTERFALSEPOSITIVEPROBABILITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BloomFilterFalsePositiveProbability").build();
    private static final MarshallingInfo<Double> DICTIONARYKEYTHRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DictionaryKeyThreshold").build();
    private static final MarshallingInfo<String> FORMATVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FormatVersion").build();
    private static final OrcSerDeMarshaller instance = new OrcSerDeMarshaller();

    public static OrcSerDeMarshaller getInstance() {
        return instance;
    }

    public void marshall(OrcSerDe orcSerDe, ProtocolMarshaller protocolMarshaller) {
        if (orcSerDe == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)orcSerDe.getStripeSizeBytes(), STRIPESIZEBYTES_BINDING);
            protocolMarshaller.marshall((Object)orcSerDe.getBlockSizeBytes(), BLOCKSIZEBYTES_BINDING);
            protocolMarshaller.marshall((Object)orcSerDe.getRowIndexStride(), ROWINDEXSTRIDE_BINDING);
            protocolMarshaller.marshall((Object)orcSerDe.getEnablePadding(), ENABLEPADDING_BINDING);
            protocolMarshaller.marshall((Object)orcSerDe.getPaddingTolerance(), PADDINGTOLERANCE_BINDING);
            protocolMarshaller.marshall((Object)orcSerDe.getCompression(), COMPRESSION_BINDING);
            protocolMarshaller.marshall(orcSerDe.getBloomFilterColumns(), BLOOMFILTERCOLUMNS_BINDING);
            protocolMarshaller.marshall((Object)orcSerDe.getBloomFilterFalsePositiveProbability(), BLOOMFILTERFALSEPOSITIVEPROBABILITY_BINDING);
            protocolMarshaller.marshall((Object)orcSerDe.getDictionaryKeyThreshold(), DICTIONARYKEYTHRESHOLD_BINDING);
            protocolMarshaller.marshall((Object)orcSerDe.getFormatVersion(), FORMATVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

