/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.kinesis.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/RegisterStreamConsumer" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class RegisterStreamConsumerResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * An object that represents the details of the consumer you registered. When you register a consumer, it gets an
     * ARN that is generated by Kinesis Data Streams.
     * </p>
     */
    private Consumer consumer;

    /**
     * <p>
     * An object that represents the details of the consumer you registered. When you register a consumer, it gets an
     * ARN that is generated by Kinesis Data Streams.
     * </p>
     * 
     * @param consumer
     *        An object that represents the details of the consumer you registered. When you register a consumer, it
     *        gets an ARN that is generated by Kinesis Data Streams.
     */

    public void setConsumer(Consumer consumer) {
        this.consumer = consumer;
    }

    /**
     * <p>
     * An object that represents the details of the consumer you registered. When you register a consumer, it gets an
     * ARN that is generated by Kinesis Data Streams.
     * </p>
     * 
     * @return An object that represents the details of the consumer you registered. When you register a consumer, it
     *         gets an ARN that is generated by Kinesis Data Streams.
     */

    public Consumer getConsumer() {
        return this.consumer;
    }

    /**
     * <p>
     * An object that represents the details of the consumer you registered. When you register a consumer, it gets an
     * ARN that is generated by Kinesis Data Streams.
     * </p>
     * 
     * @param consumer
     *        An object that represents the details of the consumer you registered. When you register a consumer, it
     *        gets an ARN that is generated by Kinesis Data Streams.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RegisterStreamConsumerResult withConsumer(Consumer consumer) {
        setConsumer(consumer);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getConsumer() != null)
            sb.append("Consumer: ").append(getConsumer());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof RegisterStreamConsumerResult == false)
            return false;
        RegisterStreamConsumerResult other = (RegisterStreamConsumerResult) obj;
        if (other.getConsumer() == null ^ this.getConsumer() == null)
            return false;
        if (other.getConsumer() != null && other.getConsumer().equals(this.getConsumer()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getConsumer() == null) ? 0 : getConsumer().hashCode());
        return hashCode;
    }

    @Override
    public RegisterStreamConsumerResult clone() {
        try {
            return (RegisterStreamConsumerResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
