/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kms.AWSKMSAsync;
import com.amazonaws.services.kms.AWSKMSClient;
import com.amazonaws.services.kms.model.CreateAliasRequest;
import com.amazonaws.services.kms.model.CreateGrantRequest;
import com.amazonaws.services.kms.model.CreateGrantResult;
import com.amazonaws.services.kms.model.CreateKeyRequest;
import com.amazonaws.services.kms.model.CreateKeyResult;
import com.amazonaws.services.kms.model.DecryptRequest;
import com.amazonaws.services.kms.model.DecryptResult;
import com.amazonaws.services.kms.model.DeleteAliasRequest;
import com.amazonaws.services.kms.model.DescribeKeyRequest;
import com.amazonaws.services.kms.model.DescribeKeyResult;
import com.amazonaws.services.kms.model.DisableKeyRequest;
import com.amazonaws.services.kms.model.DisableKeyRotationRequest;
import com.amazonaws.services.kms.model.EnableKeyRequest;
import com.amazonaws.services.kms.model.EnableKeyRotationRequest;
import com.amazonaws.services.kms.model.EncryptRequest;
import com.amazonaws.services.kms.model.EncryptResult;
import com.amazonaws.services.kms.model.GenerateDataKeyRequest;
import com.amazonaws.services.kms.model.GenerateDataKeyResult;
import com.amazonaws.services.kms.model.GenerateDataKeyWithoutPlaintextRequest;
import com.amazonaws.services.kms.model.GenerateDataKeyWithoutPlaintextResult;
import com.amazonaws.services.kms.model.GenerateRandomRequest;
import com.amazonaws.services.kms.model.GenerateRandomResult;
import com.amazonaws.services.kms.model.GetKeyPolicyRequest;
import com.amazonaws.services.kms.model.GetKeyPolicyResult;
import com.amazonaws.services.kms.model.GetKeyRotationStatusRequest;
import com.amazonaws.services.kms.model.GetKeyRotationStatusResult;
import com.amazonaws.services.kms.model.ListAliasesRequest;
import com.amazonaws.services.kms.model.ListAliasesResult;
import com.amazonaws.services.kms.model.ListGrantsRequest;
import com.amazonaws.services.kms.model.ListGrantsResult;
import com.amazonaws.services.kms.model.ListKeyPoliciesRequest;
import com.amazonaws.services.kms.model.ListKeyPoliciesResult;
import com.amazonaws.services.kms.model.ListKeysRequest;
import com.amazonaws.services.kms.model.ListKeysResult;
import com.amazonaws.services.kms.model.PutKeyPolicyRequest;
import com.amazonaws.services.kms.model.ReEncryptRequest;
import com.amazonaws.services.kms.model.ReEncryptResult;
import com.amazonaws.services.kms.model.RetireGrantRequest;
import com.amazonaws.services.kms.model.RevokeGrantRequest;
import com.amazonaws.services.kms.model.UpdateAliasRequest;
import com.amazonaws.services.kms.model.UpdateKeyDescriptionRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AWSKMSAsyncClient
extends AWSKMSClient
implements AWSKMSAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AWSKMSAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AWSKMSAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSKMSAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSKMSAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AWSKMSAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSKMSAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSKMSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AWSKMSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSKMSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<CreateKeyResult> createKeyAsync(final CreateKeyRequest createKeyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateKeyResult>(){

            @Override
            public CreateKeyResult call() throws Exception {
                return AWSKMSAsyncClient.this.createKey(createKeyRequest);
            }
        });
    }

    @Override
    public Future<CreateKeyResult> createKeyAsync(final CreateKeyRequest createKeyRequest, final AsyncHandler<CreateKeyRequest, CreateKeyResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateKeyResult>(){

            @Override
            public CreateKeyResult call() throws Exception {
                CreateKeyResult result;
                try {
                    result = AWSKMSAsyncClient.this.createKey(createKeyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createKeyRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<EncryptResult> encryptAsync(final EncryptRequest encryptRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EncryptResult>(){

            @Override
            public EncryptResult call() throws Exception {
                return AWSKMSAsyncClient.this.encrypt(encryptRequest);
            }
        });
    }

    @Override
    public Future<EncryptResult> encryptAsync(final EncryptRequest encryptRequest, final AsyncHandler<EncryptRequest, EncryptResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EncryptResult>(){

            @Override
            public EncryptResult call() throws Exception {
                EncryptResult result;
                try {
                    result = AWSKMSAsyncClient.this.encrypt(encryptRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)encryptRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetKeyPolicyResult> getKeyPolicyAsync(final GetKeyPolicyRequest getKeyPolicyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetKeyPolicyResult>(){

            @Override
            public GetKeyPolicyResult call() throws Exception {
                return AWSKMSAsyncClient.this.getKeyPolicy(getKeyPolicyRequest);
            }
        });
    }

    @Override
    public Future<GetKeyPolicyResult> getKeyPolicyAsync(final GetKeyPolicyRequest getKeyPolicyRequest, final AsyncHandler<GetKeyPolicyRequest, GetKeyPolicyResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetKeyPolicyResult>(){

            @Override
            public GetKeyPolicyResult call() throws Exception {
                GetKeyPolicyResult result;
                try {
                    result = AWSKMSAsyncClient.this.getKeyPolicy(getKeyPolicyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getKeyPolicyRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> updateKeyDescriptionAsync(final UpdateKeyDescriptionRequest updateKeyDescriptionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSKMSAsyncClient.this.updateKeyDescription(updateKeyDescriptionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateKeyDescriptionAsync(final UpdateKeyDescriptionRequest updateKeyDescriptionRequest, final AsyncHandler<UpdateKeyDescriptionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSKMSAsyncClient.this.updateKeyDescription(updateKeyDescriptionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateKeyDescriptionRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ListKeysResult> listKeysAsync(final ListKeysRequest listKeysRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListKeysResult>(){

            @Override
            public ListKeysResult call() throws Exception {
                return AWSKMSAsyncClient.this.listKeys(listKeysRequest);
            }
        });
    }

    @Override
    public Future<ListKeysResult> listKeysAsync(final ListKeysRequest listKeysRequest, final AsyncHandler<ListKeysRequest, ListKeysResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListKeysResult>(){

            @Override
            public ListKeysResult call() throws Exception {
                ListKeysResult result;
                try {
                    result = AWSKMSAsyncClient.this.listKeys(listKeysRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listKeysRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GenerateDataKeyResult> generateDataKeyAsync(final GenerateDataKeyRequest generateDataKeyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GenerateDataKeyResult>(){

            @Override
            public GenerateDataKeyResult call() throws Exception {
                return AWSKMSAsyncClient.this.generateDataKey(generateDataKeyRequest);
            }
        });
    }

    @Override
    public Future<GenerateDataKeyResult> generateDataKeyAsync(final GenerateDataKeyRequest generateDataKeyRequest, final AsyncHandler<GenerateDataKeyRequest, GenerateDataKeyResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GenerateDataKeyResult>(){

            @Override
            public GenerateDataKeyResult call() throws Exception {
                GenerateDataKeyResult result;
                try {
                    result = AWSKMSAsyncClient.this.generateDataKey(generateDataKeyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)generateDataKeyRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateGrantResult> createGrantAsync(final CreateGrantRequest createGrantRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateGrantResult>(){

            @Override
            public CreateGrantResult call() throws Exception {
                return AWSKMSAsyncClient.this.createGrant(createGrantRequest);
            }
        });
    }

    @Override
    public Future<CreateGrantResult> createGrantAsync(final CreateGrantRequest createGrantRequest, final AsyncHandler<CreateGrantRequest, CreateGrantResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateGrantResult>(){

            @Override
            public CreateGrantResult call() throws Exception {
                CreateGrantResult result;
                try {
                    result = AWSKMSAsyncClient.this.createGrant(createGrantRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createGrantRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListAliasesResult> listAliasesAsync(final ListAliasesRequest listAliasesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListAliasesResult>(){

            @Override
            public ListAliasesResult call() throws Exception {
                return AWSKMSAsyncClient.this.listAliases(listAliasesRequest);
            }
        });
    }

    @Override
    public Future<ListAliasesResult> listAliasesAsync(final ListAliasesRequest listAliasesRequest, final AsyncHandler<ListAliasesRequest, ListAliasesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListAliasesResult>(){

            @Override
            public ListAliasesResult call() throws Exception {
                ListAliasesResult result;
                try {
                    result = AWSKMSAsyncClient.this.listAliases(listAliasesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listAliasesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GenerateDataKeyWithoutPlaintextResult> generateDataKeyWithoutPlaintextAsync(final GenerateDataKeyWithoutPlaintextRequest generateDataKeyWithoutPlaintextRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GenerateDataKeyWithoutPlaintextResult>(){

            @Override
            public GenerateDataKeyWithoutPlaintextResult call() throws Exception {
                return AWSKMSAsyncClient.this.generateDataKeyWithoutPlaintext(generateDataKeyWithoutPlaintextRequest);
            }
        });
    }

    @Override
    public Future<GenerateDataKeyWithoutPlaintextResult> generateDataKeyWithoutPlaintextAsync(final GenerateDataKeyWithoutPlaintextRequest generateDataKeyWithoutPlaintextRequest, final AsyncHandler<GenerateDataKeyWithoutPlaintextRequest, GenerateDataKeyWithoutPlaintextResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GenerateDataKeyWithoutPlaintextResult>(){

            @Override
            public GenerateDataKeyWithoutPlaintextResult call() throws Exception {
                GenerateDataKeyWithoutPlaintextResult result;
                try {
                    result = AWSKMSAsyncClient.this.generateDataKeyWithoutPlaintext(generateDataKeyWithoutPlaintextRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)generateDataKeyWithoutPlaintextRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteAliasAsync(final DeleteAliasRequest deleteAliasRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSKMSAsyncClient.this.deleteAlias(deleteAliasRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteAliasAsync(final DeleteAliasRequest deleteAliasRequest, final AsyncHandler<DeleteAliasRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSKMSAsyncClient.this.deleteAlias(deleteAliasRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteAliasRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateAliasAsync(final UpdateAliasRequest updateAliasRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSKMSAsyncClient.this.updateAlias(updateAliasRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateAliasAsync(final UpdateAliasRequest updateAliasRequest, final AsyncHandler<UpdateAliasRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSKMSAsyncClient.this.updateAlias(updateAliasRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateAliasRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> enableKeyRotationAsync(final EnableKeyRotationRequest enableKeyRotationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSKMSAsyncClient.this.enableKeyRotation(enableKeyRotationRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> enableKeyRotationAsync(final EnableKeyRotationRequest enableKeyRotationRequest, final AsyncHandler<EnableKeyRotationRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSKMSAsyncClient.this.enableKeyRotation(enableKeyRotationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)enableKeyRotationRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> retireGrantAsync(final RetireGrantRequest retireGrantRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSKMSAsyncClient.this.retireGrant(retireGrantRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> retireGrantAsync(final RetireGrantRequest retireGrantRequest, final AsyncHandler<RetireGrantRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSKMSAsyncClient.this.retireGrant(retireGrantRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)retireGrantRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeKeyResult> describeKeyAsync(final DescribeKeyRequest describeKeyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeKeyResult>(){

            @Override
            public DescribeKeyResult call() throws Exception {
                return AWSKMSAsyncClient.this.describeKey(describeKeyRequest);
            }
        });
    }

    @Override
    public Future<DescribeKeyResult> describeKeyAsync(final DescribeKeyRequest describeKeyRequest, final AsyncHandler<DescribeKeyRequest, DescribeKeyResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeKeyResult>(){

            @Override
            public DescribeKeyResult call() throws Exception {
                DescribeKeyResult result;
                try {
                    result = AWSKMSAsyncClient.this.describeKey(describeKeyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeKeyRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListGrantsResult> listGrantsAsync(final ListGrantsRequest listGrantsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListGrantsResult>(){

            @Override
            public ListGrantsResult call() throws Exception {
                return AWSKMSAsyncClient.this.listGrants(listGrantsRequest);
            }
        });
    }

    @Override
    public Future<ListGrantsResult> listGrantsAsync(final ListGrantsRequest listGrantsRequest, final AsyncHandler<ListGrantsRequest, ListGrantsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListGrantsResult>(){

            @Override
            public ListGrantsResult call() throws Exception {
                ListGrantsResult result;
                try {
                    result = AWSKMSAsyncClient.this.listGrants(listGrantsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listGrantsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DecryptResult> decryptAsync(final DecryptRequest decryptRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DecryptResult>(){

            @Override
            public DecryptResult call() throws Exception {
                return AWSKMSAsyncClient.this.decrypt(decryptRequest);
            }
        });
    }

    @Override
    public Future<DecryptResult> decryptAsync(final DecryptRequest decryptRequest, final AsyncHandler<DecryptRequest, DecryptResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DecryptResult>(){

            @Override
            public DecryptResult call() throws Exception {
                DecryptResult result;
                try {
                    result = AWSKMSAsyncClient.this.decrypt(decryptRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)decryptRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GenerateRandomResult> generateRandomAsync(final GenerateRandomRequest generateRandomRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GenerateRandomResult>(){

            @Override
            public GenerateRandomResult call() throws Exception {
                return AWSKMSAsyncClient.this.generateRandom(generateRandomRequest);
            }
        });
    }

    @Override
    public Future<GenerateRandomResult> generateRandomAsync(final GenerateRandomRequest generateRandomRequest, final AsyncHandler<GenerateRandomRequest, GenerateRandomResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GenerateRandomResult>(){

            @Override
            public GenerateRandomResult call() throws Exception {
                GenerateRandomResult result;
                try {
                    result = AWSKMSAsyncClient.this.generateRandom(generateRandomRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)generateRandomRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetKeyRotationStatusResult> getKeyRotationStatusAsync(final GetKeyRotationStatusRequest getKeyRotationStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetKeyRotationStatusResult>(){

            @Override
            public GetKeyRotationStatusResult call() throws Exception {
                return AWSKMSAsyncClient.this.getKeyRotationStatus(getKeyRotationStatusRequest);
            }
        });
    }

    @Override
    public Future<GetKeyRotationStatusResult> getKeyRotationStatusAsync(final GetKeyRotationStatusRequest getKeyRotationStatusRequest, final AsyncHandler<GetKeyRotationStatusRequest, GetKeyRotationStatusResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetKeyRotationStatusResult>(){

            @Override
            public GetKeyRotationStatusResult call() throws Exception {
                GetKeyRotationStatusResult result;
                try {
                    result = AWSKMSAsyncClient.this.getKeyRotationStatus(getKeyRotationStatusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getKeyRotationStatusRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> disableKeyRotationAsync(final DisableKeyRotationRequest disableKeyRotationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSKMSAsyncClient.this.disableKeyRotation(disableKeyRotationRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> disableKeyRotationAsync(final DisableKeyRotationRequest disableKeyRotationRequest, final AsyncHandler<DisableKeyRotationRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSKMSAsyncClient.this.disableKeyRotation(disableKeyRotationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)disableKeyRotationRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ListKeyPoliciesResult> listKeyPoliciesAsync(final ListKeyPoliciesRequest listKeyPoliciesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListKeyPoliciesResult>(){

            @Override
            public ListKeyPoliciesResult call() throws Exception {
                return AWSKMSAsyncClient.this.listKeyPolicies(listKeyPoliciesRequest);
            }
        });
    }

    @Override
    public Future<ListKeyPoliciesResult> listKeyPoliciesAsync(final ListKeyPoliciesRequest listKeyPoliciesRequest, final AsyncHandler<ListKeyPoliciesRequest, ListKeyPoliciesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListKeyPoliciesResult>(){

            @Override
            public ListKeyPoliciesResult call() throws Exception {
                ListKeyPoliciesResult result;
                try {
                    result = AWSKMSAsyncClient.this.listKeyPolicies(listKeyPoliciesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listKeyPoliciesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> createAliasAsync(final CreateAliasRequest createAliasRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSKMSAsyncClient.this.createAlias(createAliasRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createAliasAsync(final CreateAliasRequest createAliasRequest, final AsyncHandler<CreateAliasRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSKMSAsyncClient.this.createAlias(createAliasRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createAliasRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putKeyPolicyAsync(final PutKeyPolicyRequest putKeyPolicyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSKMSAsyncClient.this.putKeyPolicy(putKeyPolicyRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putKeyPolicyAsync(final PutKeyPolicyRequest putKeyPolicyRequest, final AsyncHandler<PutKeyPolicyRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSKMSAsyncClient.this.putKeyPolicy(putKeyPolicyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)putKeyPolicyRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> disableKeyAsync(final DisableKeyRequest disableKeyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSKMSAsyncClient.this.disableKey(disableKeyRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> disableKeyAsync(final DisableKeyRequest disableKeyRequest, final AsyncHandler<DisableKeyRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSKMSAsyncClient.this.disableKey(disableKeyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)disableKeyRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ReEncryptResult> reEncryptAsync(final ReEncryptRequest reEncryptRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReEncryptResult>(){

            @Override
            public ReEncryptResult call() throws Exception {
                return AWSKMSAsyncClient.this.reEncrypt(reEncryptRequest);
            }
        });
    }

    @Override
    public Future<ReEncryptResult> reEncryptAsync(final ReEncryptRequest reEncryptRequest, final AsyncHandler<ReEncryptRequest, ReEncryptResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReEncryptResult>(){

            @Override
            public ReEncryptResult call() throws Exception {
                ReEncryptResult result;
                try {
                    result = AWSKMSAsyncClient.this.reEncrypt(reEncryptRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)reEncryptRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> revokeGrantAsync(final RevokeGrantRequest revokeGrantRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSKMSAsyncClient.this.revokeGrant(revokeGrantRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> revokeGrantAsync(final RevokeGrantRequest revokeGrantRequest, final AsyncHandler<RevokeGrantRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSKMSAsyncClient.this.revokeGrant(revokeGrantRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)revokeGrantRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> enableKeyAsync(final EnableKeyRequest enableKeyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSKMSAsyncClient.this.enableKey(enableKeyRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> enableKeyAsync(final EnableKeyRequest enableKeyRequest, final AsyncHandler<EnableKeyRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSKMSAsyncClient.this.enableKey(enableKeyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)enableKeyRequest, null);
                return null;
            }
        });
    }
}

