/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelbuilding.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.lexmodelbuilding.model.MergeStrategy;
import com.amazonaws.services.lexmodelbuilding.model.ResourceType;
import com.amazonaws.services.lexmodelbuilding.model.Tag;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartImportRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ByteBuffer payload;
    private String resourceType;
    private String mergeStrategy;
    private List<Tag> tags;

    public void setPayload(ByteBuffer payload) {
        this.payload = payload;
    }

    public ByteBuffer getPayload() {
        return this.payload;
    }

    public StartImportRequest withPayload(ByteBuffer payload) {
        this.setPayload(payload);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public StartImportRequest withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public StartImportRequest withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public void setMergeStrategy(String mergeStrategy) {
        this.mergeStrategy = mergeStrategy;
    }

    public String getMergeStrategy() {
        return this.mergeStrategy;
    }

    public StartImportRequest withMergeStrategy(String mergeStrategy) {
        this.setMergeStrategy(mergeStrategy);
        return this;
    }

    public StartImportRequest withMergeStrategy(MergeStrategy mergeStrategy) {
        this.mergeStrategy = mergeStrategy.toString();
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public StartImportRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public StartImportRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPayload() != null) {
            sb.append("Payload: ").append(this.getPayload()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getMergeStrategy() != null) {
            sb.append("MergeStrategy: ").append(this.getMergeStrategy()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportRequest)) {
            return false;
        }
        StartImportRequest other = (StartImportRequest)obj;
        if (other.getPayload() == null ^ this.getPayload() == null) {
            return false;
        }
        if (other.getPayload() != null && !other.getPayload().equals(this.getPayload())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getMergeStrategy() == null ^ this.getMergeStrategy() == null) {
            return false;
        }
        if (other.getMergeStrategy() != null && !other.getMergeStrategy().equals(this.getMergeStrategy())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPayload() == null ? 0 : this.getPayload().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getMergeStrategy() == null ? 0 : this.getMergeStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public StartImportRequest clone() {
        return (StartImportRequest)super.clone();
    }
}

