/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lexmodelsv2.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Contains specifications about the Amazon Lex build time generative AI capabilities from Amazon Bedrock that you can
 * turn on for your bot.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BuildtimeSettings" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class BuildtimeSettings implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * An object containing specifications for the descriptive bot building feature.
     * </p>
     */
    private DescriptiveBotBuilderSpecification descriptiveBotBuilder;

    private SampleUtteranceGenerationSpecification sampleUtteranceGeneration;

    /**
     * <p>
     * An object containing specifications for the descriptive bot building feature.
     * </p>
     * 
     * @param descriptiveBotBuilder
     *        An object containing specifications for the descriptive bot building feature.
     */

    public void setDescriptiveBotBuilder(DescriptiveBotBuilderSpecification descriptiveBotBuilder) {
        this.descriptiveBotBuilder = descriptiveBotBuilder;
    }

    /**
     * <p>
     * An object containing specifications for the descriptive bot building feature.
     * </p>
     * 
     * @return An object containing specifications for the descriptive bot building feature.
     */

    public DescriptiveBotBuilderSpecification getDescriptiveBotBuilder() {
        return this.descriptiveBotBuilder;
    }

    /**
     * <p>
     * An object containing specifications for the descriptive bot building feature.
     * </p>
     * 
     * @param descriptiveBotBuilder
     *        An object containing specifications for the descriptive bot building feature.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BuildtimeSettings withDescriptiveBotBuilder(DescriptiveBotBuilderSpecification descriptiveBotBuilder) {
        setDescriptiveBotBuilder(descriptiveBotBuilder);
        return this;
    }

    /**
     * @param sampleUtteranceGeneration
     */

    public void setSampleUtteranceGeneration(SampleUtteranceGenerationSpecification sampleUtteranceGeneration) {
        this.sampleUtteranceGeneration = sampleUtteranceGeneration;
    }

    /**
     * @return
     */

    public SampleUtteranceGenerationSpecification getSampleUtteranceGeneration() {
        return this.sampleUtteranceGeneration;
    }

    /**
     * @param sampleUtteranceGeneration
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BuildtimeSettings withSampleUtteranceGeneration(SampleUtteranceGenerationSpecification sampleUtteranceGeneration) {
        setSampleUtteranceGeneration(sampleUtteranceGeneration);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDescriptiveBotBuilder() != null)
            sb.append("DescriptiveBotBuilder: ").append(getDescriptiveBotBuilder()).append(",");
        if (getSampleUtteranceGeneration() != null)
            sb.append("SampleUtteranceGeneration: ").append(getSampleUtteranceGeneration());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof BuildtimeSettings == false)
            return false;
        BuildtimeSettings other = (BuildtimeSettings) obj;
        if (other.getDescriptiveBotBuilder() == null ^ this.getDescriptiveBotBuilder() == null)
            return false;
        if (other.getDescriptiveBotBuilder() != null && other.getDescriptiveBotBuilder().equals(this.getDescriptiveBotBuilder()) == false)
            return false;
        if (other.getSampleUtteranceGeneration() == null ^ this.getSampleUtteranceGeneration() == null)
            return false;
        if (other.getSampleUtteranceGeneration() != null && other.getSampleUtteranceGeneration().equals(this.getSampleUtteranceGeneration()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDescriptiveBotBuilder() == null) ? 0 : getDescriptiveBotBuilder().hashCode());
        hashCode = prime * hashCode + ((getSampleUtteranceGeneration() == null) ? 0 : getSampleUtteranceGeneration().hashCode());
        return hashCode;
    }

    @Override
    public BuildtimeSettings clone() {
        try {
            return (BuildtimeSettings) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.lexmodelsv2.model.transform.BuildtimeSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
