/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lexmodelsv2.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchDeleteCustomVocabularyItem"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class BatchDeleteCustomVocabularyItemRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The identifier of the bot associated with this custom vocabulary.
     * </p>
     */
    private String botId;
    /**
     * <p>
     * The identifier of the version of the bot associated with this custom vocabulary.
     * </p>
     */
    private String botVersion;
    /**
     * <p>
     * The identifier of the language and locale where this custom vocabulary is used. The string must match one of the
     * supported locales. For more information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.
     * </p>
     */
    private String localeId;
    /**
     * <p>
     * A list of custom vocabulary items requested to be deleted. Each entry must contain the unique custom vocabulary
     * entry identifier.
     * </p>
     */
    private java.util.List<CustomVocabularyEntryId> customVocabularyItemList;

    /**
     * <p>
     * The identifier of the bot associated with this custom vocabulary.
     * </p>
     * 
     * @param botId
     *        The identifier of the bot associated with this custom vocabulary.
     */

    public void setBotId(String botId) {
        this.botId = botId;
    }

    /**
     * <p>
     * The identifier of the bot associated with this custom vocabulary.
     * </p>
     * 
     * @return The identifier of the bot associated with this custom vocabulary.
     */

    public String getBotId() {
        return this.botId;
    }

    /**
     * <p>
     * The identifier of the bot associated with this custom vocabulary.
     * </p>
     * 
     * @param botId
     *        The identifier of the bot associated with this custom vocabulary.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchDeleteCustomVocabularyItemRequest withBotId(String botId) {
        setBotId(botId);
        return this;
    }

    /**
     * <p>
     * The identifier of the version of the bot associated with this custom vocabulary.
     * </p>
     * 
     * @param botVersion
     *        The identifier of the version of the bot associated with this custom vocabulary.
     */

    public void setBotVersion(String botVersion) {
        this.botVersion = botVersion;
    }

    /**
     * <p>
     * The identifier of the version of the bot associated with this custom vocabulary.
     * </p>
     * 
     * @return The identifier of the version of the bot associated with this custom vocabulary.
     */

    public String getBotVersion() {
        return this.botVersion;
    }

    /**
     * <p>
     * The identifier of the version of the bot associated with this custom vocabulary.
     * </p>
     * 
     * @param botVersion
     *        The identifier of the version of the bot associated with this custom vocabulary.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchDeleteCustomVocabularyItemRequest withBotVersion(String botVersion) {
        setBotVersion(botVersion);
        return this;
    }

    /**
     * <p>
     * The identifier of the language and locale where this custom vocabulary is used. The string must match one of the
     * supported locales. For more information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.
     * </p>
     * 
     * @param localeId
     *        The identifier of the language and locale where this custom vocabulary is used. The string must match one
     *        of the supported locales. For more information, see <a
     *        href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.
     */

    public void setLocaleId(String localeId) {
        this.localeId = localeId;
    }

    /**
     * <p>
     * The identifier of the language and locale where this custom vocabulary is used. The string must match one of the
     * supported locales. For more information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.
     * </p>
     * 
     * @return The identifier of the language and locale where this custom vocabulary is used. The string must match one
     *         of the supported locales. For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.
     */

    public String getLocaleId() {
        return this.localeId;
    }

    /**
     * <p>
     * The identifier of the language and locale where this custom vocabulary is used. The string must match one of the
     * supported locales. For more information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.
     * </p>
     * 
     * @param localeId
     *        The identifier of the language and locale where this custom vocabulary is used. The string must match one
     *        of the supported locales. For more information, see <a
     *        href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchDeleteCustomVocabularyItemRequest withLocaleId(String localeId) {
        setLocaleId(localeId);
        return this;
    }

    /**
     * <p>
     * A list of custom vocabulary items requested to be deleted. Each entry must contain the unique custom vocabulary
     * entry identifier.
     * </p>
     * 
     * @return A list of custom vocabulary items requested to be deleted. Each entry must contain the unique custom
     *         vocabulary entry identifier.
     */

    public java.util.List<CustomVocabularyEntryId> getCustomVocabularyItemList() {
        return customVocabularyItemList;
    }

    /**
     * <p>
     * A list of custom vocabulary items requested to be deleted. Each entry must contain the unique custom vocabulary
     * entry identifier.
     * </p>
     * 
     * @param customVocabularyItemList
     *        A list of custom vocabulary items requested to be deleted. Each entry must contain the unique custom
     *        vocabulary entry identifier.
     */

    public void setCustomVocabularyItemList(java.util.Collection<CustomVocabularyEntryId> customVocabularyItemList) {
        if (customVocabularyItemList == null) {
            this.customVocabularyItemList = null;
            return;
        }

        this.customVocabularyItemList = new java.util.ArrayList<CustomVocabularyEntryId>(customVocabularyItemList);
    }

    /**
     * <p>
     * A list of custom vocabulary items requested to be deleted. Each entry must contain the unique custom vocabulary
     * entry identifier.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setCustomVocabularyItemList(java.util.Collection)} or
     * {@link #withCustomVocabularyItemList(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param customVocabularyItemList
     *        A list of custom vocabulary items requested to be deleted. Each entry must contain the unique custom
     *        vocabulary entry identifier.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchDeleteCustomVocabularyItemRequest withCustomVocabularyItemList(CustomVocabularyEntryId... customVocabularyItemList) {
        if (this.customVocabularyItemList == null) {
            setCustomVocabularyItemList(new java.util.ArrayList<CustomVocabularyEntryId>(customVocabularyItemList.length));
        }
        for (CustomVocabularyEntryId ele : customVocabularyItemList) {
            this.customVocabularyItemList.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of custom vocabulary items requested to be deleted. Each entry must contain the unique custom vocabulary
     * entry identifier.
     * </p>
     * 
     * @param customVocabularyItemList
     *        A list of custom vocabulary items requested to be deleted. Each entry must contain the unique custom
     *        vocabulary entry identifier.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchDeleteCustomVocabularyItemRequest withCustomVocabularyItemList(java.util.Collection<CustomVocabularyEntryId> customVocabularyItemList) {
        setCustomVocabularyItemList(customVocabularyItemList);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getBotId() != null)
            sb.append("BotId: ").append(getBotId()).append(",");
        if (getBotVersion() != null)
            sb.append("BotVersion: ").append(getBotVersion()).append(",");
        if (getLocaleId() != null)
            sb.append("LocaleId: ").append(getLocaleId()).append(",");
        if (getCustomVocabularyItemList() != null)
            sb.append("CustomVocabularyItemList: ").append(getCustomVocabularyItemList());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof BatchDeleteCustomVocabularyItemRequest == false)
            return false;
        BatchDeleteCustomVocabularyItemRequest other = (BatchDeleteCustomVocabularyItemRequest) obj;
        if (other.getBotId() == null ^ this.getBotId() == null)
            return false;
        if (other.getBotId() != null && other.getBotId().equals(this.getBotId()) == false)
            return false;
        if (other.getBotVersion() == null ^ this.getBotVersion() == null)
            return false;
        if (other.getBotVersion() != null && other.getBotVersion().equals(this.getBotVersion()) == false)
            return false;
        if (other.getLocaleId() == null ^ this.getLocaleId() == null)
            return false;
        if (other.getLocaleId() != null && other.getLocaleId().equals(this.getLocaleId()) == false)
            return false;
        if (other.getCustomVocabularyItemList() == null ^ this.getCustomVocabularyItemList() == null)
            return false;
        if (other.getCustomVocabularyItemList() != null && other.getCustomVocabularyItemList().equals(this.getCustomVocabularyItemList()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getBotId() == null) ? 0 : getBotId().hashCode());
        hashCode = prime * hashCode + ((getBotVersion() == null) ? 0 : getBotVersion().hashCode());
        hashCode = prime * hashCode + ((getLocaleId() == null) ? 0 : getLocaleId().hashCode());
        hashCode = prime * hashCode + ((getCustomVocabularyItemList() == null) ? 0 : getCustomVocabularyItemList().hashCode());
        return hashCode;
    }

    @Override
    public BatchDeleteCustomVocabularyItemRequest clone() {
        return (BatchDeleteCustomVocabularyItemRequest) super.clone();
    }

}
