/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntimev2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexruntimev2.model.Shape;
import com.amazonaws.services.lexruntimev2.model.Value;
import com.amazonaws.services.lexruntimev2.model.transform.SlotMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Slot
implements Serializable,
Cloneable,
StructuredPojo {
    private Value value;
    private String shape;
    private List<Slot> values;

    public void setValue(Value value) {
        this.value = value;
    }

    public Value getValue() {
        return this.value;
    }

    public Slot withValue(Value value) {
        this.setValue(value);
        return this;
    }

    public void setShape(String shape) {
        this.shape = shape;
    }

    public String getShape() {
        return this.shape;
    }

    public Slot withShape(String shape) {
        this.setShape(shape);
        return this;
    }

    public Slot withShape(Shape shape) {
        this.shape = shape.toString();
        return this;
    }

    public List<Slot> getValues() {
        return this.values;
    }

    public void setValues(Collection<Slot> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new ArrayList<Slot>(values);
    }

    public Slot withValues(Slot ... values) {
        if (this.values == null) {
            this.setValues(new ArrayList<Slot>(values.length));
        }
        for (Slot ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    public Slot withValues(Collection<Slot> values) {
        this.setValues(values);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue()).append(",");
        }
        if (this.getShape() != null) {
            sb.append("Shape: ").append(this.getShape()).append(",");
        }
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Slot)) {
            return false;
        }
        Slot other = (Slot)obj;
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        if (other.getValue() != null && !other.getValue().equals(this.getValue())) {
            return false;
        }
        if (other.getShape() == null ^ this.getShape() == null) {
            return false;
        }
        if (other.getShape() != null && !other.getShape().equals(this.getShape())) {
            return false;
        }
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        return other.getValues() == null || other.getValues().equals(this.getValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        hashCode = 31 * hashCode + (this.getShape() == null ? 0 : this.getShape().hashCode());
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        return hashCode;
    }

    public Slot clone() {
        try {
            return (Slot)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SlotMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

