/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntimev2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexruntimev2.model.SessionState;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class SessionStateMarshaller {
    private static final MarshallingInfo<StructuredPojo> DIALOGACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dialogAction").build();
    private static final MarshallingInfo<StructuredPojo> INTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("intent").build();
    private static final MarshallingInfo<List> ACTIVECONTEXTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activeContexts").build();
    private static final MarshallingInfo<Map> SESSIONATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sessionAttributes").build();
    private static final MarshallingInfo<String> ORIGINATINGREQUESTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("originatingRequestId").build();
    private static final MarshallingInfo<StructuredPojo> RUNTIMEHINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("runtimeHints").build();
    private static final SessionStateMarshaller instance = new SessionStateMarshaller();

    public static SessionStateMarshaller getInstance() {
        return instance;
    }

    public void marshall(SessionState sessionState, ProtocolMarshaller protocolMarshaller) {
        if (sessionState == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sessionState.getDialogAction(), DIALOGACTION_BINDING);
            protocolMarshaller.marshall((Object)sessionState.getIntent(), INTENT_BINDING);
            protocolMarshaller.marshall(sessionState.getActiveContexts(), ACTIVECONTEXTS_BINDING);
            protocolMarshaller.marshall(sessionState.getSessionAttributes(), SESSIONATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)sessionState.getOriginatingRequestId(), ORIGINATINGREQUESTID_BINDING);
            protocolMarshaller.marshall((Object)sessionState.getRuntimeHints(), RUNTIMEHINTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

