/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntimev2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexruntimev2.model.ActiveContext;
import com.amazonaws.services.lexruntimev2.model.DialogAction;
import com.amazonaws.services.lexruntimev2.model.Intent;
import com.amazonaws.services.lexruntimev2.model.RuntimeHints;
import com.amazonaws.services.lexruntimev2.model.transform.SessionStateMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SessionState
implements Serializable,
Cloneable,
StructuredPojo {
    private DialogAction dialogAction;
    private Intent intent;
    private List<ActiveContext> activeContexts;
    private Map<String, String> sessionAttributes;
    private String originatingRequestId;
    private RuntimeHints runtimeHints;

    public void setDialogAction(DialogAction dialogAction) {
        this.dialogAction = dialogAction;
    }

    public DialogAction getDialogAction() {
        return this.dialogAction;
    }

    public SessionState withDialogAction(DialogAction dialogAction) {
        this.setDialogAction(dialogAction);
        return this;
    }

    public void setIntent(Intent intent) {
        this.intent = intent;
    }

    public Intent getIntent() {
        return this.intent;
    }

    public SessionState withIntent(Intent intent) {
        this.setIntent(intent);
        return this;
    }

    public List<ActiveContext> getActiveContexts() {
        return this.activeContexts;
    }

    public void setActiveContexts(Collection<ActiveContext> activeContexts) {
        if (activeContexts == null) {
            this.activeContexts = null;
            return;
        }
        this.activeContexts = new ArrayList<ActiveContext>(activeContexts);
    }

    public SessionState withActiveContexts(ActiveContext ... activeContexts) {
        if (this.activeContexts == null) {
            this.setActiveContexts(new ArrayList<ActiveContext>(activeContexts.length));
        }
        for (ActiveContext ele : activeContexts) {
            this.activeContexts.add(ele);
        }
        return this;
    }

    public SessionState withActiveContexts(Collection<ActiveContext> activeContexts) {
        this.setActiveContexts(activeContexts);
        return this;
    }

    public Map<String, String> getSessionAttributes() {
        return this.sessionAttributes;
    }

    public void setSessionAttributes(Map<String, String> sessionAttributes) {
        this.sessionAttributes = sessionAttributes;
    }

    public SessionState withSessionAttributes(Map<String, String> sessionAttributes) {
        this.setSessionAttributes(sessionAttributes);
        return this;
    }

    public SessionState addSessionAttributesEntry(String key, String value) {
        if (null == this.sessionAttributes) {
            this.sessionAttributes = new HashMap<String, String>();
        }
        if (this.sessionAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.sessionAttributes.put(key, value);
        return this;
    }

    public SessionState clearSessionAttributesEntries() {
        this.sessionAttributes = null;
        return this;
    }

    public void setOriginatingRequestId(String originatingRequestId) {
        this.originatingRequestId = originatingRequestId;
    }

    public String getOriginatingRequestId() {
        return this.originatingRequestId;
    }

    public SessionState withOriginatingRequestId(String originatingRequestId) {
        this.setOriginatingRequestId(originatingRequestId);
        return this;
    }

    public void setRuntimeHints(RuntimeHints runtimeHints) {
        this.runtimeHints = runtimeHints;
    }

    public RuntimeHints getRuntimeHints() {
        return this.runtimeHints;
    }

    public SessionState withRuntimeHints(RuntimeHints runtimeHints) {
        this.setRuntimeHints(runtimeHints);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDialogAction() != null) {
            sb.append("DialogAction: ").append(this.getDialogAction()).append(",");
        }
        if (this.getIntent() != null) {
            sb.append("Intent: ").append(this.getIntent()).append(",");
        }
        if (this.getActiveContexts() != null) {
            sb.append("ActiveContexts: ").append(this.getActiveContexts()).append(",");
        }
        if (this.getSessionAttributes() != null) {
            sb.append("SessionAttributes: ").append(this.getSessionAttributes()).append(",");
        }
        if (this.getOriginatingRequestId() != null) {
            sb.append("OriginatingRequestId: ").append(this.getOriginatingRequestId()).append(",");
        }
        if (this.getRuntimeHints() != null) {
            sb.append("RuntimeHints: ").append(this.getRuntimeHints());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionState)) {
            return false;
        }
        SessionState other = (SessionState)obj;
        if (other.getDialogAction() == null ^ this.getDialogAction() == null) {
            return false;
        }
        if (other.getDialogAction() != null && !other.getDialogAction().equals(this.getDialogAction())) {
            return false;
        }
        if (other.getIntent() == null ^ this.getIntent() == null) {
            return false;
        }
        if (other.getIntent() != null && !other.getIntent().equals(this.getIntent())) {
            return false;
        }
        if (other.getActiveContexts() == null ^ this.getActiveContexts() == null) {
            return false;
        }
        if (other.getActiveContexts() != null && !other.getActiveContexts().equals(this.getActiveContexts())) {
            return false;
        }
        if (other.getSessionAttributes() == null ^ this.getSessionAttributes() == null) {
            return false;
        }
        if (other.getSessionAttributes() != null && !other.getSessionAttributes().equals(this.getSessionAttributes())) {
            return false;
        }
        if (other.getOriginatingRequestId() == null ^ this.getOriginatingRequestId() == null) {
            return false;
        }
        if (other.getOriginatingRequestId() != null && !other.getOriginatingRequestId().equals(this.getOriginatingRequestId())) {
            return false;
        }
        if (other.getRuntimeHints() == null ^ this.getRuntimeHints() == null) {
            return false;
        }
        return other.getRuntimeHints() == null || other.getRuntimeHints().equals(this.getRuntimeHints());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDialogAction() == null ? 0 : this.getDialogAction().hashCode());
        hashCode = 31 * hashCode + (this.getIntent() == null ? 0 : this.getIntent().hashCode());
        hashCode = 31 * hashCode + (this.getActiveContexts() == null ? 0 : this.getActiveContexts().hashCode());
        hashCode = 31 * hashCode + (this.getSessionAttributes() == null ? 0 : this.getSessionAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getOriginatingRequestId() == null ? 0 : this.getOriginatingRequestId().hashCode());
        hashCode = 31 * hashCode + (this.getRuntimeHints() == null ? 0 : this.getRuntimeHints().hashCode());
        return hashCode;
    }

    public SessionState clone() {
        try {
            return (SessionState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SessionStateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

