/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.location.model.GeofenceGeometry;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PutGeofenceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String collectionName;
    private String geofenceId;
    private Map<String, String> geofenceProperties;
    private GeofenceGeometry geometry;

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public PutGeofenceRequest withCollectionName(String collectionName) {
        this.setCollectionName(collectionName);
        return this;
    }

    public void setGeofenceId(String geofenceId) {
        this.geofenceId = geofenceId;
    }

    public String getGeofenceId() {
        return this.geofenceId;
    }

    public PutGeofenceRequest withGeofenceId(String geofenceId) {
        this.setGeofenceId(geofenceId);
        return this;
    }

    public Map<String, String> getGeofenceProperties() {
        return this.geofenceProperties;
    }

    public void setGeofenceProperties(Map<String, String> geofenceProperties) {
        this.geofenceProperties = geofenceProperties;
    }

    public PutGeofenceRequest withGeofenceProperties(Map<String, String> geofenceProperties) {
        this.setGeofenceProperties(geofenceProperties);
        return this;
    }

    public PutGeofenceRequest addGeofencePropertiesEntry(String key, String value) {
        if (null == this.geofenceProperties) {
            this.geofenceProperties = new HashMap<String, String>();
        }
        if (this.geofenceProperties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.geofenceProperties.put(key, value);
        return this;
    }

    public PutGeofenceRequest clearGeofencePropertiesEntries() {
        this.geofenceProperties = null;
        return this;
    }

    public void setGeometry(GeofenceGeometry geometry) {
        this.geometry = geometry;
    }

    public GeofenceGeometry getGeometry() {
        return this.geometry;
    }

    public PutGeofenceRequest withGeometry(GeofenceGeometry geometry) {
        this.setGeometry(geometry);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCollectionName() != null) {
            sb.append("CollectionName: ").append(this.getCollectionName()).append(",");
        }
        if (this.getGeofenceId() != null) {
            sb.append("GeofenceId: ").append(this.getGeofenceId()).append(",");
        }
        if (this.getGeofenceProperties() != null) {
            sb.append("GeofenceProperties: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getGeometry() != null) {
            sb.append("Geometry: ").append(this.getGeometry());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutGeofenceRequest)) {
            return false;
        }
        PutGeofenceRequest other = (PutGeofenceRequest)obj;
        if (other.getCollectionName() == null ^ this.getCollectionName() == null) {
            return false;
        }
        if (other.getCollectionName() != null && !other.getCollectionName().equals(this.getCollectionName())) {
            return false;
        }
        if (other.getGeofenceId() == null ^ this.getGeofenceId() == null) {
            return false;
        }
        if (other.getGeofenceId() != null && !other.getGeofenceId().equals(this.getGeofenceId())) {
            return false;
        }
        if (other.getGeofenceProperties() == null ^ this.getGeofenceProperties() == null) {
            return false;
        }
        if (other.getGeofenceProperties() != null && !other.getGeofenceProperties().equals(this.getGeofenceProperties())) {
            return false;
        }
        if (other.getGeometry() == null ^ this.getGeometry() == null) {
            return false;
        }
        return other.getGeometry() == null || other.getGeometry().equals(this.getGeometry());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCollectionName() == null ? 0 : this.getCollectionName().hashCode());
        hashCode = 31 * hashCode + (this.getGeofenceId() == null ? 0 : this.getGeofenceId().hashCode());
        hashCode = 31 * hashCode + (this.getGeofenceProperties() == null ? 0 : this.getGeofenceProperties().hashCode());
        hashCode = 31 * hashCode + (this.getGeometry() == null ? 0 : this.getGeometry().hashCode());
        return hashCode;
    }

    public PutGeofenceRequest clone() {
        return (PutGeofenceRequest)super.clone();
    }
}

