/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.logs.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogAnomalyDetector" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetLogAnomalyDetectorRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The ARN of the anomaly detector to retrieve information about. You can find the ARNs of log anomaly detectors in
     * your account by using the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListLogAnomalyDetectors.html"
     * >ListLogAnomalyDetectors</a> operation.
     * </p>
     */
    private String anomalyDetectorArn;

    /**
     * <p>
     * The ARN of the anomaly detector to retrieve information about. You can find the ARNs of log anomaly detectors in
     * your account by using the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListLogAnomalyDetectors.html"
     * >ListLogAnomalyDetectors</a> operation.
     * </p>
     * 
     * @param anomalyDetectorArn
     *        The ARN of the anomaly detector to retrieve information about. You can find the ARNs of log anomaly
     *        detectors in your account by using the <a href=
     *        "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListLogAnomalyDetectors.html"
     *        >ListLogAnomalyDetectors</a> operation.
     */

    public void setAnomalyDetectorArn(String anomalyDetectorArn) {
        this.anomalyDetectorArn = anomalyDetectorArn;
    }

    /**
     * <p>
     * The ARN of the anomaly detector to retrieve information about. You can find the ARNs of log anomaly detectors in
     * your account by using the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListLogAnomalyDetectors.html"
     * >ListLogAnomalyDetectors</a> operation.
     * </p>
     * 
     * @return The ARN of the anomaly detector to retrieve information about. You can find the ARNs of log anomaly
     *         detectors in your account by using the <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListLogAnomalyDetectors.html"
     *         >ListLogAnomalyDetectors</a> operation.
     */

    public String getAnomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    /**
     * <p>
     * The ARN of the anomaly detector to retrieve information about. You can find the ARNs of log anomaly detectors in
     * your account by using the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListLogAnomalyDetectors.html"
     * >ListLogAnomalyDetectors</a> operation.
     * </p>
     * 
     * @param anomalyDetectorArn
     *        The ARN of the anomaly detector to retrieve information about. You can find the ARNs of log anomaly
     *        detectors in your account by using the <a href=
     *        "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListLogAnomalyDetectors.html"
     *        >ListLogAnomalyDetectors</a> operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetLogAnomalyDetectorRequest withAnomalyDetectorArn(String anomalyDetectorArn) {
        setAnomalyDetectorArn(anomalyDetectorArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAnomalyDetectorArn() != null)
            sb.append("AnomalyDetectorArn: ").append(getAnomalyDetectorArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetLogAnomalyDetectorRequest == false)
            return false;
        GetLogAnomalyDetectorRequest other = (GetLogAnomalyDetectorRequest) obj;
        if (other.getAnomalyDetectorArn() == null ^ this.getAnomalyDetectorArn() == null)
            return false;
        if (other.getAnomalyDetectorArn() != null && other.getAnomalyDetectorArn().equals(this.getAnomalyDetectorArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAnomalyDetectorArn() == null) ? 0 : getAnomalyDetectorArn().hashCode());
        return hashCode;
    }

    @Override
    public GetLogAnomalyDetectorRequest clone() {
        return (GetLogAnomalyDetectorRequest) super.clone();
    }

}
