/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.logs.model.transform.DeliverySourceMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DeliverySource
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String arn;
    private SdkInternalList<String> resourceArns;
    private String service;
    private String logType;
    private SdkInternalMap<String, String> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DeliverySource withName(String name) {
        this.setName(name);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public DeliverySource withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public List<String> getResourceArns() {
        if (this.resourceArns == null) {
            this.resourceArns = new SdkInternalList();
        }
        return this.resourceArns;
    }

    public void setResourceArns(Collection<String> resourceArns) {
        if (resourceArns == null) {
            this.resourceArns = null;
            return;
        }
        this.resourceArns = new SdkInternalList(resourceArns);
    }

    public DeliverySource withResourceArns(String ... resourceArns) {
        if (this.resourceArns == null) {
            this.setResourceArns((Collection<String>)new SdkInternalList(resourceArns.length));
        }
        for (String ele : resourceArns) {
            this.resourceArns.add((Object)ele);
        }
        return this;
    }

    public DeliverySource withResourceArns(Collection<String> resourceArns) {
        this.setResourceArns(resourceArns);
        return this;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getService() {
        return this.service;
    }

    public DeliverySource withService(String service) {
        this.setService(service);
        return this;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public String getLogType() {
        return this.logType;
    }

    public DeliverySource withLogType(String logType) {
        this.setLogType(logType);
        return this;
    }

    public Map<String, String> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalMap();
        }
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags == null ? null : new SdkInternalMap(tags);
    }

    public DeliverySource withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public DeliverySource addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new SdkInternalMap();
        }
        if (this.tags.containsKey((Object)key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put((Object)key, (Object)value);
        return this;
    }

    public DeliverySource clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getResourceArns() != null) {
            sb.append("ResourceArns: ").append(this.getResourceArns()).append(",");
        }
        if (this.getService() != null) {
            sb.append("Service: ").append(this.getService()).append(",");
        }
        if (this.getLogType() != null) {
            sb.append("LogType: ").append(this.getLogType()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliverySource)) {
            return false;
        }
        DeliverySource other = (DeliverySource)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getResourceArns() == null ^ this.getResourceArns() == null) {
            return false;
        }
        if (other.getResourceArns() != null && !other.getResourceArns().equals(this.getResourceArns())) {
            return false;
        }
        if (other.getService() == null ^ this.getService() == null) {
            return false;
        }
        if (other.getService() != null && !other.getService().equals(this.getService())) {
            return false;
        }
        if (other.getLogType() == null ^ this.getLogType() == null) {
            return false;
        }
        if (other.getLogType() != null && !other.getLogType().equals(this.getLogType())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getResourceArns() == null ? 0 : this.getResourceArns().hashCode());
        hashCode = 31 * hashCode + (this.getService() == null ? 0 : this.getService().hashCode());
        hashCode = 31 * hashCode + (this.getLogType() == null ? 0 : this.getLogType().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public DeliverySource clone() {
        try {
            return (DeliverySource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeliverySourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

