/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model.transform;

import com.amazonaws.services.macie2.model.Page;
import com.amazonaws.services.macie2.model.transform.RangeJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class PageJsonUnmarshaller
implements Unmarshaller<Page, JsonUnmarshallerContext> {
    private static PageJsonUnmarshaller instance;

    public Page unmarshall(JsonUnmarshallerContext context) throws Exception {
        Page page = new Page();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("lineRange", targetDepth)) {
                    context.nextToken();
                    page.setLineRange(RangeJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("offsetRange", targetDepth)) {
                    context.nextToken();
                    page.setOffsetRange(RangeJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("pageNumber", targetDepth)) {
                    context.nextToken();
                    page.setPageNumber((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return page;
    }

    public static PageJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PageJsonUnmarshaller();
        }
        return instance;
    }
}

