/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mailmanager.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The authentication configuration for the ingress endpoint resource.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/IngressPointAuthConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class IngressPointAuthConfiguration implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The ingress endpoint password configuration for the ingress endpoint resource.
     * </p>
     */
    private IngressPointPasswordConfiguration ingressPointPasswordConfiguration;
    /**
     * <p>
     * The ingress endpoint SecretsManager::Secret ARN configuration for the ingress endpoint resource.
     * </p>
     */
    private String secretArn;

    /**
     * <p>
     * The ingress endpoint password configuration for the ingress endpoint resource.
     * </p>
     * 
     * @param ingressPointPasswordConfiguration
     *        The ingress endpoint password configuration for the ingress endpoint resource.
     */

    public void setIngressPointPasswordConfiguration(IngressPointPasswordConfiguration ingressPointPasswordConfiguration) {
        this.ingressPointPasswordConfiguration = ingressPointPasswordConfiguration;
    }

    /**
     * <p>
     * The ingress endpoint password configuration for the ingress endpoint resource.
     * </p>
     * 
     * @return The ingress endpoint password configuration for the ingress endpoint resource.
     */

    public IngressPointPasswordConfiguration getIngressPointPasswordConfiguration() {
        return this.ingressPointPasswordConfiguration;
    }

    /**
     * <p>
     * The ingress endpoint password configuration for the ingress endpoint resource.
     * </p>
     * 
     * @param ingressPointPasswordConfiguration
     *        The ingress endpoint password configuration for the ingress endpoint resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public IngressPointAuthConfiguration withIngressPointPasswordConfiguration(IngressPointPasswordConfiguration ingressPointPasswordConfiguration) {
        setIngressPointPasswordConfiguration(ingressPointPasswordConfiguration);
        return this;
    }

    /**
     * <p>
     * The ingress endpoint SecretsManager::Secret ARN configuration for the ingress endpoint resource.
     * </p>
     * 
     * @param secretArn
     *        The ingress endpoint SecretsManager::Secret ARN configuration for the ingress endpoint resource.
     */

    public void setSecretArn(String secretArn) {
        this.secretArn = secretArn;
    }

    /**
     * <p>
     * The ingress endpoint SecretsManager::Secret ARN configuration for the ingress endpoint resource.
     * </p>
     * 
     * @return The ingress endpoint SecretsManager::Secret ARN configuration for the ingress endpoint resource.
     */

    public String getSecretArn() {
        return this.secretArn;
    }

    /**
     * <p>
     * The ingress endpoint SecretsManager::Secret ARN configuration for the ingress endpoint resource.
     * </p>
     * 
     * @param secretArn
     *        The ingress endpoint SecretsManager::Secret ARN configuration for the ingress endpoint resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public IngressPointAuthConfiguration withSecretArn(String secretArn) {
        setSecretArn(secretArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getIngressPointPasswordConfiguration() != null)
            sb.append("IngressPointPasswordConfiguration: ").append(getIngressPointPasswordConfiguration()).append(",");
        if (getSecretArn() != null)
            sb.append("SecretArn: ").append(getSecretArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof IngressPointAuthConfiguration == false)
            return false;
        IngressPointAuthConfiguration other = (IngressPointAuthConfiguration) obj;
        if (other.getIngressPointPasswordConfiguration() == null ^ this.getIngressPointPasswordConfiguration() == null)
            return false;
        if (other.getIngressPointPasswordConfiguration() != null
                && other.getIngressPointPasswordConfiguration().equals(this.getIngressPointPasswordConfiguration()) == false)
            return false;
        if (other.getSecretArn() == null ^ this.getSecretArn() == null)
            return false;
        if (other.getSecretArn() != null && other.getSecretArn().equals(this.getSecretArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getIngressPointPasswordConfiguration() == null) ? 0 : getIngressPointPasswordConfiguration().hashCode());
        hashCode = prime * hashCode + ((getSecretArn() == null) ? 0 : getSecretArn().hashCode());
        return hashCode;
    }

    @Override
    public IngressPointAuthConfiguration clone() {
        try {
            return (IngressPointAuthConfiguration) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.mailmanager.model.transform.IngressPointAuthConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
