/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediapackage;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.mediapackage.AWSMediaPackageAsync;
import com.amazonaws.services.mediapackage.AWSMediaPackageAsyncClientBuilder;
import com.amazonaws.services.mediapackage.AWSMediaPackageClient;
import com.amazonaws.services.mediapackage.model.CreateChannelRequest;
import com.amazonaws.services.mediapackage.model.CreateChannelResult;
import com.amazonaws.services.mediapackage.model.CreateOriginEndpointRequest;
import com.amazonaws.services.mediapackage.model.CreateOriginEndpointResult;
import com.amazonaws.services.mediapackage.model.DeleteChannelRequest;
import com.amazonaws.services.mediapackage.model.DeleteChannelResult;
import com.amazonaws.services.mediapackage.model.DeleteOriginEndpointRequest;
import com.amazonaws.services.mediapackage.model.DeleteOriginEndpointResult;
import com.amazonaws.services.mediapackage.model.DescribeChannelRequest;
import com.amazonaws.services.mediapackage.model.DescribeChannelResult;
import com.amazonaws.services.mediapackage.model.DescribeOriginEndpointRequest;
import com.amazonaws.services.mediapackage.model.DescribeOriginEndpointResult;
import com.amazonaws.services.mediapackage.model.ListChannelsRequest;
import com.amazonaws.services.mediapackage.model.ListChannelsResult;
import com.amazonaws.services.mediapackage.model.ListOriginEndpointsRequest;
import com.amazonaws.services.mediapackage.model.ListOriginEndpointsResult;
import com.amazonaws.services.mediapackage.model.ListTagsForResourceRequest;
import com.amazonaws.services.mediapackage.model.ListTagsForResourceResult;
import com.amazonaws.services.mediapackage.model.RotateChannelCredentialsRequest;
import com.amazonaws.services.mediapackage.model.RotateChannelCredentialsResult;
import com.amazonaws.services.mediapackage.model.RotateIngestEndpointCredentialsRequest;
import com.amazonaws.services.mediapackage.model.RotateIngestEndpointCredentialsResult;
import com.amazonaws.services.mediapackage.model.TagResourceRequest;
import com.amazonaws.services.mediapackage.model.TagResourceResult;
import com.amazonaws.services.mediapackage.model.UntagResourceRequest;
import com.amazonaws.services.mediapackage.model.UntagResourceResult;
import com.amazonaws.services.mediapackage.model.UpdateChannelRequest;
import com.amazonaws.services.mediapackage.model.UpdateChannelResult;
import com.amazonaws.services.mediapackage.model.UpdateOriginEndpointRequest;
import com.amazonaws.services.mediapackage.model.UpdateOriginEndpointResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSMediaPackageAsyncClient
extends AWSMediaPackageClient
implements AWSMediaPackageAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSMediaPackageAsyncClientBuilder asyncBuilder() {
        return AWSMediaPackageAsyncClientBuilder.standard();
    }

    AWSMediaPackageAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateChannelResult> createChannelAsync(CreateChannelRequest request) {
        return this.createChannelAsync(request, null);
    }

    @Override
    public Future<CreateChannelResult> createChannelAsync(CreateChannelRequest request, final AsyncHandler<CreateChannelRequest, CreateChannelResult> asyncHandler) {
        final CreateChannelRequest finalRequest = (CreateChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateChannelResult>(){

            @Override
            public CreateChannelResult call() throws Exception {
                CreateChannelResult result = null;
                try {
                    result = AWSMediaPackageAsyncClient.this.executeCreateChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateOriginEndpointResult> createOriginEndpointAsync(CreateOriginEndpointRequest request) {
        return this.createOriginEndpointAsync(request, null);
    }

    @Override
    public Future<CreateOriginEndpointResult> createOriginEndpointAsync(CreateOriginEndpointRequest request, final AsyncHandler<CreateOriginEndpointRequest, CreateOriginEndpointResult> asyncHandler) {
        final CreateOriginEndpointRequest finalRequest = (CreateOriginEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateOriginEndpointResult>(){

            @Override
            public CreateOriginEndpointResult call() throws Exception {
                CreateOriginEndpointResult result = null;
                try {
                    result = AWSMediaPackageAsyncClient.this.executeCreateOriginEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteChannelResult> deleteChannelAsync(DeleteChannelRequest request) {
        return this.deleteChannelAsync(request, null);
    }

    @Override
    public Future<DeleteChannelResult> deleteChannelAsync(DeleteChannelRequest request, final AsyncHandler<DeleteChannelRequest, DeleteChannelResult> asyncHandler) {
        final DeleteChannelRequest finalRequest = (DeleteChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteChannelResult>(){

            @Override
            public DeleteChannelResult call() throws Exception {
                DeleteChannelResult result = null;
                try {
                    result = AWSMediaPackageAsyncClient.this.executeDeleteChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteOriginEndpointResult> deleteOriginEndpointAsync(DeleteOriginEndpointRequest request) {
        return this.deleteOriginEndpointAsync(request, null);
    }

    @Override
    public Future<DeleteOriginEndpointResult> deleteOriginEndpointAsync(DeleteOriginEndpointRequest request, final AsyncHandler<DeleteOriginEndpointRequest, DeleteOriginEndpointResult> asyncHandler) {
        final DeleteOriginEndpointRequest finalRequest = (DeleteOriginEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteOriginEndpointResult>(){

            @Override
            public DeleteOriginEndpointResult call() throws Exception {
                DeleteOriginEndpointResult result = null;
                try {
                    result = AWSMediaPackageAsyncClient.this.executeDeleteOriginEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeChannelResult> describeChannelAsync(DescribeChannelRequest request) {
        return this.describeChannelAsync(request, null);
    }

    @Override
    public Future<DescribeChannelResult> describeChannelAsync(DescribeChannelRequest request, final AsyncHandler<DescribeChannelRequest, DescribeChannelResult> asyncHandler) {
        final DescribeChannelRequest finalRequest = (DescribeChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeChannelResult>(){

            @Override
            public DescribeChannelResult call() throws Exception {
                DescribeChannelResult result = null;
                try {
                    result = AWSMediaPackageAsyncClient.this.executeDescribeChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeOriginEndpointResult> describeOriginEndpointAsync(DescribeOriginEndpointRequest request) {
        return this.describeOriginEndpointAsync(request, null);
    }

    @Override
    public Future<DescribeOriginEndpointResult> describeOriginEndpointAsync(DescribeOriginEndpointRequest request, final AsyncHandler<DescribeOriginEndpointRequest, DescribeOriginEndpointResult> asyncHandler) {
        final DescribeOriginEndpointRequest finalRequest = (DescribeOriginEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeOriginEndpointResult>(){

            @Override
            public DescribeOriginEndpointResult call() throws Exception {
                DescribeOriginEndpointResult result = null;
                try {
                    result = AWSMediaPackageAsyncClient.this.executeDescribeOriginEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListChannelsResult> listChannelsAsync(ListChannelsRequest request) {
        return this.listChannelsAsync(request, null);
    }

    @Override
    public Future<ListChannelsResult> listChannelsAsync(ListChannelsRequest request, final AsyncHandler<ListChannelsRequest, ListChannelsResult> asyncHandler) {
        final ListChannelsRequest finalRequest = (ListChannelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListChannelsResult>(){

            @Override
            public ListChannelsResult call() throws Exception {
                ListChannelsResult result = null;
                try {
                    result = AWSMediaPackageAsyncClient.this.executeListChannels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListOriginEndpointsResult> listOriginEndpointsAsync(ListOriginEndpointsRequest request) {
        return this.listOriginEndpointsAsync(request, null);
    }

    @Override
    public Future<ListOriginEndpointsResult> listOriginEndpointsAsync(ListOriginEndpointsRequest request, final AsyncHandler<ListOriginEndpointsRequest, ListOriginEndpointsResult> asyncHandler) {
        final ListOriginEndpointsRequest finalRequest = (ListOriginEndpointsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListOriginEndpointsResult>(){

            @Override
            public ListOriginEndpointsResult call() throws Exception {
                ListOriginEndpointsResult result = null;
                try {
                    result = AWSMediaPackageAsyncClient.this.executeListOriginEndpoints(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSMediaPackageAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    @Deprecated
    public Future<RotateChannelCredentialsResult> rotateChannelCredentialsAsync(RotateChannelCredentialsRequest request) {
        return this.rotateChannelCredentialsAsync(request, null);
    }

    @Override
    @Deprecated
    public Future<RotateChannelCredentialsResult> rotateChannelCredentialsAsync(RotateChannelCredentialsRequest request, final AsyncHandler<RotateChannelCredentialsRequest, RotateChannelCredentialsResult> asyncHandler) {
        final RotateChannelCredentialsRequest finalRequest = (RotateChannelCredentialsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RotateChannelCredentialsResult>(){

            @Override
            public RotateChannelCredentialsResult call() throws Exception {
                RotateChannelCredentialsResult result = null;
                try {
                    result = AWSMediaPackageAsyncClient.this.executeRotateChannelCredentials(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RotateIngestEndpointCredentialsResult> rotateIngestEndpointCredentialsAsync(RotateIngestEndpointCredentialsRequest request) {
        return this.rotateIngestEndpointCredentialsAsync(request, null);
    }

    @Override
    public Future<RotateIngestEndpointCredentialsResult> rotateIngestEndpointCredentialsAsync(RotateIngestEndpointCredentialsRequest request, final AsyncHandler<RotateIngestEndpointCredentialsRequest, RotateIngestEndpointCredentialsResult> asyncHandler) {
        final RotateIngestEndpointCredentialsRequest finalRequest = (RotateIngestEndpointCredentialsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RotateIngestEndpointCredentialsResult>(){

            @Override
            public RotateIngestEndpointCredentialsResult call() throws Exception {
                RotateIngestEndpointCredentialsResult result = null;
                try {
                    result = AWSMediaPackageAsyncClient.this.executeRotateIngestEndpointCredentials(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSMediaPackageAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSMediaPackageAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateChannelResult> updateChannelAsync(UpdateChannelRequest request) {
        return this.updateChannelAsync(request, null);
    }

    @Override
    public Future<UpdateChannelResult> updateChannelAsync(UpdateChannelRequest request, final AsyncHandler<UpdateChannelRequest, UpdateChannelResult> asyncHandler) {
        final UpdateChannelRequest finalRequest = (UpdateChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateChannelResult>(){

            @Override
            public UpdateChannelResult call() throws Exception {
                UpdateChannelResult result = null;
                try {
                    result = AWSMediaPackageAsyncClient.this.executeUpdateChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateOriginEndpointResult> updateOriginEndpointAsync(UpdateOriginEndpointRequest request) {
        return this.updateOriginEndpointAsync(request, null);
    }

    @Override
    public Future<UpdateOriginEndpointResult> updateOriginEndpointAsync(UpdateOriginEndpointRequest request, final AsyncHandler<UpdateOriginEndpointRequest, UpdateOriginEndpointResult> asyncHandler) {
        final UpdateOriginEndpointRequest finalRequest = (UpdateOriginEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateOriginEndpointResult>(){

            @Override
            public UpdateOriginEndpointResult call() throws Exception {
                UpdateOriginEndpointResult result = null;
                try {
                    result = AWSMediaPackageAsyncClient.this.executeUpdateOriginEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

