/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediapackagevod.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.mediapackagevod.model.AssetShallow;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListAssetsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<AssetShallow> assets;
    private String nextToken;

    public List<AssetShallow> getAssets() {
        return this.assets;
    }

    public void setAssets(Collection<AssetShallow> assets) {
        if (assets == null) {
            this.assets = null;
            return;
        }
        this.assets = new ArrayList<AssetShallow>(assets);
    }

    public ListAssetsResult withAssets(AssetShallow ... assets) {
        if (this.assets == null) {
            this.setAssets(new ArrayList<AssetShallow>(assets.length));
        }
        for (AssetShallow ele : assets) {
            this.assets.add(ele);
        }
        return this;
    }

    public ListAssetsResult withAssets(Collection<AssetShallow> assets) {
        this.setAssets(assets);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListAssetsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssets() != null) {
            sb.append("Assets: ").append(this.getAssets()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssetsResult)) {
            return false;
        }
        ListAssetsResult other = (ListAssetsResult)obj;
        if (other.getAssets() == null ^ this.getAssets() == null) {
            return false;
        }
        if (other.getAssets() != null && !other.getAssets().equals(this.getAssets())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssets() == null ? 0 : this.getAssets().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListAssetsResult clone() {
        try {
            return (ListAssetsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

