/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediastore.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.mediastore.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateContainerRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String containerName;
    private List<Tag> tags;

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public CreateContainerRequest withContainerName(String containerName) {
        this.setContainerName(containerName);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateContainerRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateContainerRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainerName() != null) {
            sb.append("ContainerName: ").append(this.getContainerName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContainerRequest)) {
            return false;
        }
        CreateContainerRequest other = (CreateContainerRequest)obj;
        if (other.getContainerName() == null ^ this.getContainerName() == null) {
            return false;
        }
        if (other.getContainerName() != null && !other.getContainerName().equals(this.getContainerName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainerName() == null ? 0 : this.getContainerName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateContainerRequest clone() {
        return (CreateContainerRequest)super.clone();
    }
}

