/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediatailor.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.mediatailor.model.RequestOutputItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateChannelRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String channelName;
    private List<RequestOutputItem> outputs;

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public UpdateChannelRequest withChannelName(String channelName) {
        this.setChannelName(channelName);
        return this;
    }

    public List<RequestOutputItem> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Collection<RequestOutputItem> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }
        this.outputs = new ArrayList<RequestOutputItem>(outputs);
    }

    public UpdateChannelRequest withOutputs(RequestOutputItem ... outputs) {
        if (this.outputs == null) {
            this.setOutputs(new ArrayList<RequestOutputItem>(outputs.length));
        }
        for (RequestOutputItem ele : outputs) {
            this.outputs.add(ele);
        }
        return this;
    }

    public UpdateChannelRequest withOutputs(Collection<RequestOutputItem> outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getChannelName() != null) {
            sb.append("ChannelName: ").append(this.getChannelName()).append(",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: ").append(this.getOutputs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelRequest)) {
            return false;
        }
        UpdateChannelRequest other = (UpdateChannelRequest)obj;
        if (other.getChannelName() == null ^ this.getChannelName() == null) {
            return false;
        }
        if (other.getChannelName() != null && !other.getChannelName().equals(this.getChannelName())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        return other.getOutputs() == null || other.getOutputs().equals(this.getOutputs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getChannelName() == null ? 0 : this.getChannelName().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        return hashCode;
    }

    public UpdateChannelRequest clone() {
        return (UpdateChannelRequest)super.clone();
    }
}

