/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediatailor;

import javax.annotation.Generated;

import com.amazonaws.services.mediatailor.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSMediaTailor}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSMediaTailor implements AWSMediaTailor {

    protected AbstractAWSMediaTailor() {
    }

    @Override
    public ConfigureLogsForChannelResult configureLogsForChannel(ConfigureLogsForChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ConfigureLogsForPlaybackConfigurationResult configureLogsForPlaybackConfiguration(ConfigureLogsForPlaybackConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateChannelResult createChannel(CreateChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLiveSourceResult createLiveSource(CreateLiveSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePrefetchScheduleResult createPrefetchSchedule(CreatePrefetchScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProgramResult createProgram(CreateProgramRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSourceLocationResult createSourceLocation(CreateSourceLocationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateVodSourceResult createVodSource(CreateVodSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteChannelResult deleteChannel(DeleteChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteChannelPolicyResult deleteChannelPolicy(DeleteChannelPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLiveSourceResult deleteLiveSource(DeleteLiveSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePlaybackConfigurationResult deletePlaybackConfiguration(DeletePlaybackConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePrefetchScheduleResult deletePrefetchSchedule(DeletePrefetchScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProgramResult deleteProgram(DeleteProgramRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSourceLocationResult deleteSourceLocation(DeleteSourceLocationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVodSourceResult deleteVodSource(DeleteVodSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeChannelResult describeChannel(DescribeChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeLiveSourceResult describeLiveSource(DescribeLiveSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeProgramResult describeProgram(DescribeProgramRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeSourceLocationResult describeSourceLocation(DescribeSourceLocationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeVodSourceResult describeVodSource(DescribeVodSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetChannelPolicyResult getChannelPolicy(GetChannelPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetChannelScheduleResult getChannelSchedule(GetChannelScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPlaybackConfigurationResult getPlaybackConfiguration(GetPlaybackConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPrefetchScheduleResult getPrefetchSchedule(GetPrefetchScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAlertsResult listAlerts(ListAlertsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChannelsResult listChannels(ListChannelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLiveSourcesResult listLiveSources(ListLiveSourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPlaybackConfigurationsResult listPlaybackConfigurations(ListPlaybackConfigurationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPrefetchSchedulesResult listPrefetchSchedules(ListPrefetchSchedulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSourceLocationsResult listSourceLocations(ListSourceLocationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVodSourcesResult listVodSources(ListVodSourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutChannelPolicyResult putChannelPolicy(PutChannelPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutPlaybackConfigurationResult putPlaybackConfiguration(PutPlaybackConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartChannelResult startChannel(StartChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopChannelResult stopChannel(StopChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateChannelResult updateChannel(UpdateChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateLiveSourceResult updateLiveSource(UpdateLiveSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateProgramResult updateProgram(UpdateProgramRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSourceLocationResult updateSourceLocation(UpdateSourceLocationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateVodSourceResult updateVodSource(UpdateVodSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
