/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediatailor.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediatailor.model.SegmentationDescriptor;
import com.amazonaws.services.mediatailor.model.transform.TimeSignalMessageMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TimeSignalMessage
implements Serializable,
Cloneable,
StructuredPojo {
    private List<SegmentationDescriptor> segmentationDescriptors;

    public List<SegmentationDescriptor> getSegmentationDescriptors() {
        return this.segmentationDescriptors;
    }

    public void setSegmentationDescriptors(Collection<SegmentationDescriptor> segmentationDescriptors) {
        if (segmentationDescriptors == null) {
            this.segmentationDescriptors = null;
            return;
        }
        this.segmentationDescriptors = new ArrayList<SegmentationDescriptor>(segmentationDescriptors);
    }

    public TimeSignalMessage withSegmentationDescriptors(SegmentationDescriptor ... segmentationDescriptors) {
        if (this.segmentationDescriptors == null) {
            this.setSegmentationDescriptors(new ArrayList<SegmentationDescriptor>(segmentationDescriptors.length));
        }
        for (SegmentationDescriptor ele : segmentationDescriptors) {
            this.segmentationDescriptors.add(ele);
        }
        return this;
    }

    public TimeSignalMessage withSegmentationDescriptors(Collection<SegmentationDescriptor> segmentationDescriptors) {
        this.setSegmentationDescriptors(segmentationDescriptors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSegmentationDescriptors() != null) {
            sb.append("SegmentationDescriptors: ").append(this.getSegmentationDescriptors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSignalMessage)) {
            return false;
        }
        TimeSignalMessage other = (TimeSignalMessage)obj;
        if (other.getSegmentationDescriptors() == null ^ this.getSegmentationDescriptors() == null) {
            return false;
        }
        return other.getSegmentationDescriptors() == null || other.getSegmentationDescriptors().equals(this.getSegmentationDescriptors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSegmentationDescriptors() == null ? 0 : this.getSegmentationDescriptors().hashCode());
        return hashCode;
    }

    public TimeSignalMessage clone() {
        try {
            return (TimeSignalMessage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimeSignalMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

