/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.memorydb.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.memorydb.model.ACLsUpdateStatus;
import com.amazonaws.services.memorydb.model.PendingModifiedServiceUpdate;
import com.amazonaws.services.memorydb.model.ReshardingStatus;
import com.amazonaws.services.memorydb.model.transform.ClusterPendingUpdatesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClusterPendingUpdates
implements Serializable,
Cloneable,
StructuredPojo {
    private ReshardingStatus resharding;
    private ACLsUpdateStatus aCLs;
    private List<PendingModifiedServiceUpdate> serviceUpdates;

    public void setResharding(ReshardingStatus resharding) {
        this.resharding = resharding;
    }

    public ReshardingStatus getResharding() {
        return this.resharding;
    }

    public ClusterPendingUpdates withResharding(ReshardingStatus resharding) {
        this.setResharding(resharding);
        return this;
    }

    public void setACLs(ACLsUpdateStatus aCLs) {
        this.aCLs = aCLs;
    }

    public ACLsUpdateStatus getACLs() {
        return this.aCLs;
    }

    public ClusterPendingUpdates withACLs(ACLsUpdateStatus aCLs) {
        this.setACLs(aCLs);
        return this;
    }

    public List<PendingModifiedServiceUpdate> getServiceUpdates() {
        return this.serviceUpdates;
    }

    public void setServiceUpdates(Collection<PendingModifiedServiceUpdate> serviceUpdates) {
        if (serviceUpdates == null) {
            this.serviceUpdates = null;
            return;
        }
        this.serviceUpdates = new ArrayList<PendingModifiedServiceUpdate>(serviceUpdates);
    }

    public ClusterPendingUpdates withServiceUpdates(PendingModifiedServiceUpdate ... serviceUpdates) {
        if (this.serviceUpdates == null) {
            this.setServiceUpdates(new ArrayList<PendingModifiedServiceUpdate>(serviceUpdates.length));
        }
        for (PendingModifiedServiceUpdate ele : serviceUpdates) {
            this.serviceUpdates.add(ele);
        }
        return this;
    }

    public ClusterPendingUpdates withServiceUpdates(Collection<PendingModifiedServiceUpdate> serviceUpdates) {
        this.setServiceUpdates(serviceUpdates);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResharding() != null) {
            sb.append("Resharding: ").append(this.getResharding()).append(",");
        }
        if (this.getACLs() != null) {
            sb.append("ACLs: ").append(this.getACLs()).append(",");
        }
        if (this.getServiceUpdates() != null) {
            sb.append("ServiceUpdates: ").append(this.getServiceUpdates());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterPendingUpdates)) {
            return false;
        }
        ClusterPendingUpdates other = (ClusterPendingUpdates)obj;
        if (other.getResharding() == null ^ this.getResharding() == null) {
            return false;
        }
        if (other.getResharding() != null && !other.getResharding().equals(this.getResharding())) {
            return false;
        }
        if (other.getACLs() == null ^ this.getACLs() == null) {
            return false;
        }
        if (other.getACLs() != null && !other.getACLs().equals(this.getACLs())) {
            return false;
        }
        if (other.getServiceUpdates() == null ^ this.getServiceUpdates() == null) {
            return false;
        }
        return other.getServiceUpdates() == null || other.getServiceUpdates().equals(this.getServiceUpdates());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResharding() == null ? 0 : this.getResharding().hashCode());
        hashCode = 31 * hashCode + (this.getACLs() == null ? 0 : this.getACLs().hashCode());
        hashCode = 31 * hashCode + (this.getServiceUpdates() == null ? 0 : this.getServiceUpdates().hashCode());
        return hashCode;
    }

    public ClusterPendingUpdates clone() {
        try {
            return (ClusterPendingUpdates)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterPendingUpdatesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

