/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mq.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Specifies a broker in a data replication pair.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DataReplicationCounterpart" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DataReplicationCounterpart implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Required. The unique broker id generated by Amazon MQ.
     * </p>
     */
    private String brokerId;
    /**
     * <p>
     * Required. The region of the broker.
     * </p>
     */
    private String region;

    /**
     * <p>
     * Required. The unique broker id generated by Amazon MQ.
     * </p>
     * 
     * @param brokerId
     *        Required. The unique broker id generated by Amazon MQ.
     */

    public void setBrokerId(String brokerId) {
        this.brokerId = brokerId;
    }

    /**
     * <p>
     * Required. The unique broker id generated by Amazon MQ.
     * </p>
     * 
     * @return Required. The unique broker id generated by Amazon MQ.
     */

    public String getBrokerId() {
        return this.brokerId;
    }

    /**
     * <p>
     * Required. The unique broker id generated by Amazon MQ.
     * </p>
     * 
     * @param brokerId
     *        Required. The unique broker id generated by Amazon MQ.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DataReplicationCounterpart withBrokerId(String brokerId) {
        setBrokerId(brokerId);
        return this;
    }

    /**
     * <p>
     * Required. The region of the broker.
     * </p>
     * 
     * @param region
     *        Required. The region of the broker.
     */

    public void setRegion(String region) {
        this.region = region;
    }

    /**
     * <p>
     * Required. The region of the broker.
     * </p>
     * 
     * @return Required. The region of the broker.
     */

    public String getRegion() {
        return this.region;
    }

    /**
     * <p>
     * Required. The region of the broker.
     * </p>
     * 
     * @param region
     *        Required. The region of the broker.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DataReplicationCounterpart withRegion(String region) {
        setRegion(region);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getBrokerId() != null)
            sb.append("BrokerId: ").append(getBrokerId()).append(",");
        if (getRegion() != null)
            sb.append("Region: ").append(getRegion());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DataReplicationCounterpart == false)
            return false;
        DataReplicationCounterpart other = (DataReplicationCounterpart) obj;
        if (other.getBrokerId() == null ^ this.getBrokerId() == null)
            return false;
        if (other.getBrokerId() != null && other.getBrokerId().equals(this.getBrokerId()) == false)
            return false;
        if (other.getRegion() == null ^ this.getRegion() == null)
            return false;
        if (other.getRegion() != null && other.getRegion().equals(this.getRegion()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getBrokerId() == null) ? 0 : getBrokerId().hashCode());
        hashCode = prime * hashCode + ((getRegion() == null) ? 0 : getRegion().hashCode());
        return hashCode;
    }

    @Override
    public DataReplicationCounterpart clone() {
        try {
            return (DataReplicationCounterpart) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.mq.model.transform.DataReplicationCounterpartMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
