/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetDevicesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String globalNetworkId;
    private List<String> deviceIds;
    private String siteId;
    private Integer maxResults;
    private String nextToken;

    public void setGlobalNetworkId(String globalNetworkId) {
        this.globalNetworkId = globalNetworkId;
    }

    public String getGlobalNetworkId() {
        return this.globalNetworkId;
    }

    public GetDevicesRequest withGlobalNetworkId(String globalNetworkId) {
        this.setGlobalNetworkId(globalNetworkId);
        return this;
    }

    public List<String> getDeviceIds() {
        return this.deviceIds;
    }

    public void setDeviceIds(Collection<String> deviceIds) {
        if (deviceIds == null) {
            this.deviceIds = null;
            return;
        }
        this.deviceIds = new ArrayList<String>(deviceIds);
    }

    public GetDevicesRequest withDeviceIds(String ... deviceIds) {
        if (this.deviceIds == null) {
            this.setDeviceIds(new ArrayList<String>(deviceIds.length));
        }
        for (String ele : deviceIds) {
            this.deviceIds.add(ele);
        }
        return this;
    }

    public GetDevicesRequest withDeviceIds(Collection<String> deviceIds) {
        this.setDeviceIds(deviceIds);
        return this;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public GetDevicesRequest withSiteId(String siteId) {
        this.setSiteId(siteId);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public GetDevicesRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetDevicesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGlobalNetworkId() != null) {
            sb.append("GlobalNetworkId: ").append(this.getGlobalNetworkId()).append(",");
        }
        if (this.getDeviceIds() != null) {
            sb.append("DeviceIds: ").append(this.getDeviceIds()).append(",");
        }
        if (this.getSiteId() != null) {
            sb.append("SiteId: ").append(this.getSiteId()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDevicesRequest)) {
            return false;
        }
        GetDevicesRequest other = (GetDevicesRequest)obj;
        if (other.getGlobalNetworkId() == null ^ this.getGlobalNetworkId() == null) {
            return false;
        }
        if (other.getGlobalNetworkId() != null && !other.getGlobalNetworkId().equals(this.getGlobalNetworkId())) {
            return false;
        }
        if (other.getDeviceIds() == null ^ this.getDeviceIds() == null) {
            return false;
        }
        if (other.getDeviceIds() != null && !other.getDeviceIds().equals(this.getDeviceIds())) {
            return false;
        }
        if (other.getSiteId() == null ^ this.getSiteId() == null) {
            return false;
        }
        if (other.getSiteId() != null && !other.getSiteId().equals(this.getSiteId())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGlobalNetworkId() == null ? 0 : this.getGlobalNetworkId().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceIds() == null ? 0 : this.getDeviceIds().hashCode());
        hashCode = 31 * hashCode + (this.getSiteId() == null ? 0 : this.getSiteId().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public GetDevicesRequest clone() {
        return (GetDevicesRequest)super.clone();
    }
}

