/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.networkmanager.model.Site;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetSitesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Site> sites;
    private String nextToken;

    public List<Site> getSites() {
        return this.sites;
    }

    public void setSites(Collection<Site> sites) {
        if (sites == null) {
            this.sites = null;
            return;
        }
        this.sites = new ArrayList<Site>(sites);
    }

    public GetSitesResult withSites(Site ... sites) {
        if (this.sites == null) {
            this.setSites(new ArrayList<Site>(sites.length));
        }
        for (Site ele : sites) {
            this.sites.add(ele);
        }
        return this;
    }

    public GetSitesResult withSites(Collection<Site> sites) {
        this.setSites(sites);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetSitesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSites() != null) {
            sb.append("Sites: ").append(this.getSites()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSitesResult)) {
            return false;
        }
        GetSitesResult other = (GetSitesResult)obj;
        if (other.getSites() == null ^ this.getSites() == null) {
            return false;
        }
        if (other.getSites() != null && !other.getSites().equals(this.getSites())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSites() == null ? 0 : this.getSites().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public GetSitesResult clone() {
        try {
            return (GetSitesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

