/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkmanager.model.Tag;
import com.amazonaws.services.networkmanager.model.transform.NetworkResourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NetworkResource
implements Serializable,
Cloneable,
StructuredPojo {
    private String registeredGatewayArn;
    private String awsRegion;
    private String accountId;
    private String resourceType;
    private String resourceId;
    private String resourceArn;
    private String definition;
    private Date definitionTimestamp;
    private List<Tag> tags;
    private Map<String, String> metadata;

    public void setRegisteredGatewayArn(String registeredGatewayArn) {
        this.registeredGatewayArn = registeredGatewayArn;
    }

    public String getRegisteredGatewayArn() {
        return this.registeredGatewayArn;
    }

    public NetworkResource withRegisteredGatewayArn(String registeredGatewayArn) {
        this.setRegisteredGatewayArn(registeredGatewayArn);
        return this;
    }

    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }

    public NetworkResource withAwsRegion(String awsRegion) {
        this.setAwsRegion(awsRegion);
        return this;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public NetworkResource withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public NetworkResource withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public NetworkResource withResourceId(String resourceId) {
        this.setResourceId(resourceId);
        return this;
    }

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public NetworkResource withResourceArn(String resourceArn) {
        this.setResourceArn(resourceArn);
        return this;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public String getDefinition() {
        return this.definition;
    }

    public NetworkResource withDefinition(String definition) {
        this.setDefinition(definition);
        return this;
    }

    public void setDefinitionTimestamp(Date definitionTimestamp) {
        this.definitionTimestamp = definitionTimestamp;
    }

    public Date getDefinitionTimestamp() {
        return this.definitionTimestamp;
    }

    public NetworkResource withDefinitionTimestamp(Date definitionTimestamp) {
        this.setDefinitionTimestamp(definitionTimestamp);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public NetworkResource withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public NetworkResource withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public NetworkResource withMetadata(Map<String, String> metadata) {
        this.setMetadata(metadata);
        return this;
    }

    public NetworkResource addMetadataEntry(String key, String value) {
        if (null == this.metadata) {
            this.metadata = new HashMap<String, String>();
        }
        if (this.metadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.metadata.put(key, value);
        return this;
    }

    public NetworkResource clearMetadataEntries() {
        this.metadata = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRegisteredGatewayArn() != null) {
            sb.append("RegisteredGatewayArn: ").append(this.getRegisteredGatewayArn()).append(",");
        }
        if (this.getAwsRegion() != null) {
            sb.append("AwsRegion: ").append(this.getAwsRegion()).append(",");
        }
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getResourceId() != null) {
            sb.append("ResourceId: ").append(this.getResourceId()).append(",");
        }
        if (this.getResourceArn() != null) {
            sb.append("ResourceArn: ").append(this.getResourceArn()).append(",");
        }
        if (this.getDefinition() != null) {
            sb.append("Definition: ").append(this.getDefinition()).append(",");
        }
        if (this.getDefinitionTimestamp() != null) {
            sb.append("DefinitionTimestamp: ").append(this.getDefinitionTimestamp()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getMetadata() != null) {
            sb.append("Metadata: ").append(this.getMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkResource)) {
            return false;
        }
        NetworkResource other = (NetworkResource)obj;
        if (other.getRegisteredGatewayArn() == null ^ this.getRegisteredGatewayArn() == null) {
            return false;
        }
        if (other.getRegisteredGatewayArn() != null && !other.getRegisteredGatewayArn().equals(this.getRegisteredGatewayArn())) {
            return false;
        }
        if (other.getAwsRegion() == null ^ this.getAwsRegion() == null) {
            return false;
        }
        if (other.getAwsRegion() != null && !other.getAwsRegion().equals(this.getAwsRegion())) {
            return false;
        }
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getResourceArn() == null ^ this.getResourceArn() == null) {
            return false;
        }
        if (other.getResourceArn() != null && !other.getResourceArn().equals(this.getResourceArn())) {
            return false;
        }
        if (other.getDefinition() == null ^ this.getDefinition() == null) {
            return false;
        }
        if (other.getDefinition() != null && !other.getDefinition().equals(this.getDefinition())) {
            return false;
        }
        if (other.getDefinitionTimestamp() == null ^ this.getDefinitionTimestamp() == null) {
            return false;
        }
        if (other.getDefinitionTimestamp() != null && !other.getDefinitionTimestamp().equals(this.getDefinitionTimestamp())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getMetadata() == null ^ this.getMetadata() == null) {
            return false;
        }
        return other.getMetadata() == null || other.getMetadata().equals(this.getMetadata());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRegisteredGatewayArn() == null ? 0 : this.getRegisteredGatewayArn().hashCode());
        hashCode = 31 * hashCode + (this.getAwsRegion() == null ? 0 : this.getAwsRegion().hashCode());
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getResourceArn() == null ? 0 : this.getResourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getDefinition() == null ? 0 : this.getDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getDefinitionTimestamp() == null ? 0 : this.getDefinitionTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getMetadata() == null ? 0 : this.getMetadata().hashCode());
        return hashCode;
    }

    public NetworkResource clone() {
        try {
            return (NetworkResource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NetworkResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

