/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.omics.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Formatting options for a TSV file.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/TsvOptions" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class TsvOptions implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The file's read options.
     * </p>
     */
    private ReadOptions readOptions;

    /**
     * <p>
     * The file's read options.
     * </p>
     * 
     * @param readOptions
     *        The file's read options.
     */

    public void setReadOptions(ReadOptions readOptions) {
        this.readOptions = readOptions;
    }

    /**
     * <p>
     * The file's read options.
     * </p>
     * 
     * @return The file's read options.
     */

    public ReadOptions getReadOptions() {
        return this.readOptions;
    }

    /**
     * <p>
     * The file's read options.
     * </p>
     * 
     * @param readOptions
     *        The file's read options.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TsvOptions withReadOptions(ReadOptions readOptions) {
        setReadOptions(readOptions);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getReadOptions() != null)
            sb.append("ReadOptions: ").append(getReadOptions());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof TsvOptions == false)
            return false;
        TsvOptions other = (TsvOptions) obj;
        if (other.getReadOptions() == null ^ this.getReadOptions() == null)
            return false;
        if (other.getReadOptions() != null && other.getReadOptions().equals(this.getReadOptions()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getReadOptions() == null) ? 0 : getReadOptions().hashCode());
        return hashCode;
    }

    @Override
    public TsvOptions clone() {
        try {
            return (TsvOptions) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.omics.model.transform.TsvOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
