/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.opensdk.protect.protocol;

import com.amazonaws.SdkBaseException;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.opensdk.BaseResult;
import com.amazonaws.opensdk.internal.protocol.ApiGatewayErrorResponseHandler;
import com.amazonaws.opensdk.internal.protocol.ApiGatewayErrorUnmarshaller;
import com.amazonaws.opensdk.internal.protocol.ApiGatewayResponseHandler;
import com.amazonaws.protocol.OperationInfo;
import com.amazonaws.protocol.ProtocolRequestMarshaller;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.JsonProtocolMarshallerBuilder;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.SdkStructuredJsonFactory;
import com.amazonaws.protocol.json.SdkStructuredPlainJsonFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ApiGatewayProtocolFactoryImpl
implements SdkJsonMarshallerFactory {
    private static final SdkStructuredJsonFactory JSON_FACTORY = SdkStructuredPlainJsonFactory.SDK_JSON_FACTORY;
    private static final String CONTENT_TYPE = "application/json";
    private final JsonClientMetadata metadata;

    public ApiGatewayProtocolFactoryImpl(JsonClientMetadata metadata) {
        this.metadata = metadata;
    }

    public StructuredJsonGenerator createGenerator() {
        return JSON_FACTORY.createWriter(CONTENT_TYPE);
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public <T> ProtocolRequestMarshaller<T> createProtocolMarshaller(OperationInfo operationInfo, T origRequest) {
        return JsonProtocolMarshallerBuilder.standard().jsonGenerator(operationInfo.hasPayloadMembers() ? this.createGenerator() : StructuredJsonGenerator.NO_OP).contentType(this.getContentType()).operationInfo(operationInfo).originalRequest(origRequest).sendExplicitNullForPayload(true).build();
    }

    public <T extends BaseResult> HttpResponseHandler<T> createResponseHandler(JsonOperationMetadata operationMetadata, Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller) {
        JsonResponseHandler responseHandler = JSON_FACTORY.createResponseHandler(operationMetadata, responseUnmarshaller);
        return new ApiGatewayResponseHandler(responseHandler);
    }

    public HttpResponseHandler<SdkBaseException> createErrorResponseHandler(JsonErrorResponseMetadata errorResponsMetadata) {
        return new ApiGatewayErrorResponseHandler(this.createErrorUnmarshallers(errorResponsMetadata.getErrorShapes().stream()), SdkStructuredPlainJsonFactory.JSON_FACTORY);
    }

    private List<ApiGatewayErrorUnmarshaller> createErrorUnmarshallers(Stream<JsonErrorShapeMetadata> errorShapeMetadata) {
        List<ApiGatewayErrorUnmarshaller> errorUnmarshallers = errorShapeMetadata.map(this::createErrorUnmarshaller).collect(Collectors.toList());
        errorUnmarshallers.add(new ApiGatewayErrorUnmarshaller(this.metadata.getBaseServiceExceptionClass(), Optional.empty()));
        return errorUnmarshallers;
    }

    private ApiGatewayErrorUnmarshaller createErrorUnmarshaller(JsonErrorShapeMetadata errorShape) {
        return new ApiGatewayErrorUnmarshaller(errorShape.getModeledClass(), Optional.of(errorShape.getHttpStatusCode()));
    }
}

