/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.opensdk;

import com.amazonaws.annotation.Immutable;
import com.amazonaws.http.SdkHttpMetadata;
import java.nio.ByteBuffer;
import java.util.Optional;

@Immutable
public class SdkErrorHttpMetadata {
    private final ByteBuffer responseContent;
    private final SdkHttpMetadata httpMetadata;

    public SdkErrorHttpMetadata(SdkHttpMetadata httpMetadata, byte[] responseContent) {
        this.httpMetadata = httpMetadata;
        this.responseContent = ByteBuffer.wrap(responseContent).asReadOnlyBuffer();
    }

    public Optional<String> header(String headerName) {
        return Optional.ofNullable(this.httpMetadata.getHttpHeaders().get(headerName));
    }

    public String requestId() {
        return (String)this.httpMetadata.getHttpHeaders().get("x-amzn-RequestId");
    }

    public int httpStatusCode() {
        return this.httpMetadata.getHttpStatusCode();
    }

    public ByteBuffer responseContent() {
        return this.responseContent;
    }
}

