/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.opensdk.protect.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.opensdk.model.RawRequest;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.transform.Marshaller;

public class RawRequestMarshaller
implements Marshaller<Request<RawRequest>, RawRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public RawRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<RawRequest> marshall(RawRequest rawRequestRequest) {
        if (rawRequestRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest("MyService");
        request.setHttpMethod(rawRequestRequest.httpMethod());
        request.setResourcePath(rawRequestRequest.path());
        request.setContent(rawRequestRequest.payload());
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

