/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.opensdk;

import com.amazonaws.annotation.Immutable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Immutable
public class SdkRequestConfig {
    private final Integer httpRequestTimeout;
    private final Integer totalExecutionTimeout;
    private final Map<String, String> customHeaders;
    private final Map<String, List<String>> customQueryParams;

    private SdkRequestConfig(Integer httpRequestTimeout, Integer totalExecutionTimeout, Map<String, String> customHeaders, Map<String, List<String>> customQueryParams) {
        this.httpRequestTimeout = httpRequestTimeout;
        this.totalExecutionTimeout = totalExecutionTimeout;
        this.customHeaders = Collections.unmodifiableMap(customHeaders);
        this.customQueryParams = Collections.unmodifiableMap(customQueryParams);
    }

    public Integer getHttpRequestTimeout() {
        return this.httpRequestTimeout;
    }

    public Integer getTotalExecutionTimeout() {
        return this.totalExecutionTimeout;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public Map<String, List<String>> getCustomQueryParams() {
        return this.customQueryParams;
    }

    public Builder copyBuilder() {
        Builder b = new Builder();
        b.httpRequestTimeout = this.httpRequestTimeout;
        b.totalExecutionTimeout = this.totalExecutionTimeout;
        b.customHeaders = new HashMap<String, String>(this.customHeaders);
        b.customQueryParams = new HashMap<String, List<String>>(this.customQueryParams);
        return b;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer httpRequestTimeout;
        private Integer totalExecutionTimeout;
        private Map<String, String> customHeaders = new HashMap<String, String>();
        private Map<String, List<String>> customQueryParams = new HashMap<String, List<String>>();

        public Builder httpRequestTimeout(int httpRequestTimeout) {
            this.httpRequestTimeout = httpRequestTimeout;
            return this;
        }

        public Builder totalExecutionTimeout(int totalExecutionTimeout) {
            this.totalExecutionTimeout = totalExecutionTimeout;
            return this;
        }

        public Builder customHeader(String name, String value) {
            this.customHeaders.put(name, value);
            return this;
        }

        public Builder customQueryParam(String name, String value) {
            this.customQueryParams.computeIfAbsent(name, key -> new ArrayList());
            this.customQueryParams.get(name).add(value);
            return this;
        }

        public SdkRequestConfig build() {
            return new SdkRequestConfig(this.httpRequestTimeout, this.totalExecutionTimeout, this.customHeaders, this.customQueryParams);
        }
    }
}

