/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.opensdk.retry;

import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.retry.v2.AndRetryCondition;
import com.amazonaws.retry.v2.BackoffStrategy;
import com.amazonaws.retry.v2.FixedDelayBackoffStrategy;
import com.amazonaws.retry.v2.MaxNumberOfRetriesCondition;
import com.amazonaws.retry.v2.OrRetryCondition;
import com.amazonaws.retry.v2.RetryCondition;
import com.amazonaws.retry.v2.RetryOnExceptionsCondition;
import com.amazonaws.retry.v2.RetryOnStatusCodeCondition;
import com.amazonaws.retry.v2.RetryPolicy;
import com.amazonaws.retry.v2.SimpleRetryPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class RetryPolicyBuilder {
    private final List<Class<? extends Exception>> exceptions = new ArrayList<Class<? extends Exception>>();
    private final List<Integer> statusCodes = new ArrayList<Integer>();
    private BackoffStrategy backoffStrategy = PredefinedRetryPolicies.DEFAULT_BACKOFF_STRATEGY_V2;
    private int maxNumberOfRetries = 3;

    public static RetryPolicyBuilder standard() {
        return new RetryPolicyBuilder();
    }

    private RetryPolicyBuilder() {
    }

    @SafeVarargs
    public final RetryPolicyBuilder retryOnExceptions(Class<? extends Exception> ... exceptions) {
        Collections.addAll(this.exceptions, exceptions);
        return this;
    }

    public RetryPolicyBuilder retryOnStatusCodes(int ... statusCodes) {
        for (int statusCode : statusCodes) {
            this.statusCodes.add(statusCode);
        }
        return this;
    }

    public RetryPolicyBuilder maxNumberOfRetries(int maxNumberOfRetries) {
        this.maxNumberOfRetries = maxNumberOfRetries;
        return this;
    }

    public RetryPolicyBuilder fixedBackoff(int backoff) {
        this.backoffStrategy = new FixedDelayBackoffStrategy(backoff);
        return this;
    }

    public RetryPolicyBuilder backoffStrategy(BackoffStrategy backoffStrategy) {
        this.backoffStrategy = backoffStrategy;
        return this;
    }

    public RetryPolicy build() {
        return new SimpleRetryPolicy(this.buildCondition(), this.backoffStrategy);
    }

    private RetryCondition buildCondition() {
        return new AndRetryCondition(new RetryCondition[]{new MaxNumberOfRetriesCondition(this.maxNumberOfRetries), new OrRetryCondition(new RetryCondition[]{new RetryOnExceptionsCondition(this.exceptions), new RetryOnStatusCodeCondition(this.statusCodes)})});
    }
}

