/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.opensdk.model;

import com.amazonaws.http.HttpMethodName;
import com.amazonaws.opensdk.BaseRequest;
import com.amazonaws.opensdk.SdkRequestConfig;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RawRequest
extends BaseRequest {
    private static final long serialVersionUID = 1L;
    private String path;
    private HttpMethodName httpMethod = HttpMethodName.GET;
    private transient InputStream payload;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, List<String>> queryParameters = new HashMap<String, List<String>>();
    private transient SdkRequestConfig requestConfig = SdkRequestConfig.builder().build();
    private boolean requestConfigDirty = true;

    public String path() {
        return this.path;
    }

    public RawRequest path(String path) {
        this.path = path;
        return this;
    }

    public HttpMethodName httpMethod() {
        return this.httpMethod;
    }

    public RawRequest httpMethod(HttpMethodName httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public RawRequest header(String name, String value) {
        this.headers.put(name, value);
        this.setRequestConfigDirty();
        return this;
    }

    public RawRequest queryParameter(String name, String value) {
        this.queryParameters.computeIfAbsent(name, k -> new ArrayList());
        this.queryParameters.get(name).add(value);
        this.setRequestConfigDirty();
        return this;
    }

    public RawRequest payload(InputStream is) {
        this.payload = is;
        return this;
    }

    public InputStream payload() {
        return this.payload;
    }

    @Override
    public RawRequest sdkRequestConfig(SdkRequestConfig sdkRequestConfig) {
        super.sdkRequestConfig(sdkRequestConfig);
        this.setRequestConfigDirty();
        return this;
    }

    @Override
    public SdkRequestConfig sdkRequestConfig() {
        if (this.requestConfigDirty) {
            SdkRequestConfig.Builder builder = super.sdkRequestConfig().copyBuilder();
            this.queryParameters.forEach((p, values) -> values.forEach(v -> builder.customQueryParam((String)p, (String)v)));
            this.headers.forEach(builder::customHeader);
            this.requestConfig = builder.build();
            this.requestConfigDirty = false;
        }
        return this.requestConfig;
    }

    private void setRequestConfigDirty() {
        this.requestConfigDirty = true;
    }
}

