/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.opensearch.model.OutboundConnection;

@SdkInternalApi
public class OutboundConnectionMarshaller {
    private static final MarshallingInfo<StructuredPojo> LOCALDOMAININFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocalDomainInfo").build();
    private static final MarshallingInfo<StructuredPojo> REMOTEDOMAININFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RemoteDomainInfo").build();
    private static final MarshallingInfo<String> CONNECTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionId").build();
    private static final MarshallingInfo<String> CONNECTIONALIAS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionAlias").build();
    private static final MarshallingInfo<StructuredPojo> CONNECTIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionStatus").build();
    private static final MarshallingInfo<String> CONNECTIONMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionMode").build();
    private static final MarshallingInfo<StructuredPojo> CONNECTIONPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionProperties").build();
    private static final OutboundConnectionMarshaller instance = new OutboundConnectionMarshaller();

    public static OutboundConnectionMarshaller getInstance() {
        return instance;
    }

    public void marshall(OutboundConnection outboundConnection, ProtocolMarshaller protocolMarshaller) {
        if (outboundConnection == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)outboundConnection.getLocalDomainInfo(), LOCALDOMAININFO_BINDING);
            protocolMarshaller.marshall((Object)outboundConnection.getRemoteDomainInfo(), REMOTEDOMAININFO_BINDING);
            protocolMarshaller.marshall((Object)outboundConnection.getConnectionId(), CONNECTIONID_BINDING);
            protocolMarshaller.marshall((Object)outboundConnection.getConnectionAlias(), CONNECTIONALIAS_BINDING);
            protocolMarshaller.marshall((Object)outboundConnection.getConnectionStatus(), CONNECTIONSTATUS_BINDING);
            protocolMarshaller.marshall((Object)outboundConnection.getConnectionMode(), CONNECTIONMODE_BINDING);
            protocolMarshaller.marshall((Object)outboundConnection.getConnectionProperties(), CONNECTIONPROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

