/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.DeploymentCommand;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Deployment
implements Serializable,
Cloneable {
    private String deploymentId;
    private String stackId;
    private String appId;
    private String createdAt;
    private String completedAt;
    private Integer duration;
    private String iamUserArn;
    private String comment;
    private DeploymentCommand command;
    private String status;
    private String customJson;
    private ListWithAutoConstructFlag<String> instanceIds;

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public Deployment withDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
        return this;
    }

    public String getStackId() {
        return this.stackId;
    }

    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    public Deployment withStackId(String stackId) {
        this.stackId = stackId;
        return this;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public Deployment withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Deployment withCreatedAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public String getCompletedAt() {
        return this.completedAt;
    }

    public void setCompletedAt(String completedAt) {
        this.completedAt = completedAt;
    }

    public Deployment withCompletedAt(String completedAt) {
        this.completedAt = completedAt;
        return this;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Deployment withDuration(Integer duration) {
        this.duration = duration;
        return this;
    }

    public String getIamUserArn() {
        return this.iamUserArn;
    }

    public void setIamUserArn(String iamUserArn) {
        this.iamUserArn = iamUserArn;
    }

    public Deployment withIamUserArn(String iamUserArn) {
        this.iamUserArn = iamUserArn;
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Deployment withComment(String comment) {
        this.comment = comment;
        return this;
    }

    public DeploymentCommand getCommand() {
        return this.command;
    }

    public void setCommand(DeploymentCommand command) {
        this.command = command;
    }

    public Deployment withCommand(DeploymentCommand command) {
        this.command = command;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Deployment withStatus(String status) {
        this.status = status;
        return this;
    }

    public String getCustomJson() {
        return this.customJson;
    }

    public void setCustomJson(String customJson) {
        this.customJson = customJson;
    }

    public Deployment withCustomJson(String customJson) {
        this.customJson = customJson;
        return this;
    }

    public List<String> getInstanceIds() {
        if (this.instanceIds == null) {
            this.instanceIds = new ListWithAutoConstructFlag();
            this.instanceIds.setAutoConstruct(true);
        }
        return this.instanceIds;
    }

    public void setInstanceIds(Collection<String> instanceIds) {
        if (instanceIds == null) {
            this.instanceIds = null;
            return;
        }
        ListWithAutoConstructFlag instanceIdsCopy = new ListWithAutoConstructFlag(instanceIds.size());
        instanceIdsCopy.addAll(instanceIds);
        this.instanceIds = instanceIdsCopy;
    }

    public Deployment withInstanceIds(String ... instanceIds) {
        if (this.getInstanceIds() == null) {
            this.setInstanceIds(new ArrayList<String>(instanceIds.length));
        }
        for (String value : instanceIds) {
            this.getInstanceIds().add(value);
        }
        return this;
    }

    public Deployment withInstanceIds(Collection<String> instanceIds) {
        if (instanceIds == null) {
            this.instanceIds = null;
        } else {
            ListWithAutoConstructFlag instanceIdsCopy = new ListWithAutoConstructFlag(instanceIds.size());
            instanceIdsCopy.addAll(instanceIds);
            this.instanceIds = instanceIdsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeploymentId() != null) {
            sb.append("DeploymentId: " + this.getDeploymentId() + ",");
        }
        if (this.getStackId() != null) {
            sb.append("StackId: " + this.getStackId() + ",");
        }
        if (this.getAppId() != null) {
            sb.append("AppId: " + this.getAppId() + ",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: " + this.getCreatedAt() + ",");
        }
        if (this.getCompletedAt() != null) {
            sb.append("CompletedAt: " + this.getCompletedAt() + ",");
        }
        if (this.getDuration() != null) {
            sb.append("Duration: " + this.getDuration() + ",");
        }
        if (this.getIamUserArn() != null) {
            sb.append("IamUserArn: " + this.getIamUserArn() + ",");
        }
        if (this.getComment() != null) {
            sb.append("Comment: " + this.getComment() + ",");
        }
        if (this.getCommand() != null) {
            sb.append("Command: " + this.getCommand() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getCustomJson() != null) {
            sb.append("CustomJson: " + this.getCustomJson() + ",");
        }
        if (this.getInstanceIds() != null) {
            sb.append("InstanceIds: " + this.getInstanceIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeploymentId() == null ? 0 : this.getDeploymentId().hashCode());
        hashCode = 31 * hashCode + (this.getStackId() == null ? 0 : this.getStackId().hashCode());
        hashCode = 31 * hashCode + (this.getAppId() == null ? 0 : this.getAppId().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getCompletedAt() == null ? 0 : this.getCompletedAt().hashCode());
        hashCode = 31 * hashCode + (this.getDuration() == null ? 0 : this.getDuration().hashCode());
        hashCode = 31 * hashCode + (this.getIamUserArn() == null ? 0 : this.getIamUserArn().hashCode());
        hashCode = 31 * hashCode + (this.getComment() == null ? 0 : this.getComment().hashCode());
        hashCode = 31 * hashCode + (this.getCommand() == null ? 0 : this.getCommand().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCustomJson() == null ? 0 : this.getCustomJson().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceIds() == null ? 0 : this.getInstanceIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment)obj;
        if (other.getDeploymentId() == null ^ this.getDeploymentId() == null) {
            return false;
        }
        if (other.getDeploymentId() != null && !other.getDeploymentId().equals(this.getDeploymentId())) {
            return false;
        }
        if (other.getStackId() == null ^ this.getStackId() == null) {
            return false;
        }
        if (other.getStackId() != null && !other.getStackId().equals(this.getStackId())) {
            return false;
        }
        if (other.getAppId() == null ^ this.getAppId() == null) {
            return false;
        }
        if (other.getAppId() != null && !other.getAppId().equals(this.getAppId())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getCompletedAt() == null ^ this.getCompletedAt() == null) {
            return false;
        }
        if (other.getCompletedAt() != null && !other.getCompletedAt().equals(this.getCompletedAt())) {
            return false;
        }
        if (other.getDuration() == null ^ this.getDuration() == null) {
            return false;
        }
        if (other.getDuration() != null && !other.getDuration().equals(this.getDuration())) {
            return false;
        }
        if (other.getIamUserArn() == null ^ this.getIamUserArn() == null) {
            return false;
        }
        if (other.getIamUserArn() != null && !other.getIamUserArn().equals(this.getIamUserArn())) {
            return false;
        }
        if (other.getComment() == null ^ this.getComment() == null) {
            return false;
        }
        if (other.getComment() != null && !other.getComment().equals(this.getComment())) {
            return false;
        }
        if (other.getCommand() == null ^ this.getCommand() == null) {
            return false;
        }
        if (other.getCommand() != null && !other.getCommand().equals(this.getCommand())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getCustomJson() == null ^ this.getCustomJson() == null) {
            return false;
        }
        if (other.getCustomJson() != null && !other.getCustomJson().equals(this.getCustomJson())) {
            return false;
        }
        if (other.getInstanceIds() == null ^ this.getInstanceIds() == null) {
            return false;
        }
        return other.getInstanceIds() == null || other.getInstanceIds().equals(this.getInstanceIds());
    }

    public Deployment clone() {
        try {
            return (Deployment)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

