/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.opsworks.model.DescribeElasticIpsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeElasticIpsRequestMarshaller
implements Marshaller<Request<DescribeElasticIpsRequest>, DescribeElasticIpsRequest> {
    public Request<DescribeElasticIpsRequest> marshall(DescribeElasticIpsRequest describeElasticIpsRequest) {
        if (describeElasticIpsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeElasticIpsRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.DescribeElasticIps");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList ipsList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (describeElasticIpsRequest.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(describeElasticIpsRequest.getInstanceId());
            }
            if (describeElasticIpsRequest.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(describeElasticIpsRequest.getStackId());
            }
            if (!(ipsList = (SdkInternalList)describeElasticIpsRequest.getIps()).isEmpty() || !ipsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Ips");
                jsonGenerator.writeStartArray();
                for (String ipsListValue : ipsList) {
                    if (ipsListValue == null) continue;
                    jsonGenerator.writeValue(ipsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

