/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.AgentVersion;
import com.amazonaws.services.opsworks.model.transform.StackConfigurationManagerJsonMarshaller;

public class AgentVersionJsonMarshaller {
    private static AgentVersionJsonMarshaller instance;

    public void marshall(AgentVersion agentVersion, StructuredJsonGenerator jsonGenerator) {
        if (agentVersion == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (agentVersion.getVersion() != null) {
                jsonGenerator.writeFieldName("Version").writeValue(agentVersion.getVersion());
            }
            if (agentVersion.getConfigurationManager() != null) {
                jsonGenerator.writeFieldName("ConfigurationManager");
                StackConfigurationManagerJsonMarshaller.getInstance().marshall(agentVersion.getConfigurationManager(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AgentVersionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AgentVersionJsonMarshaller();
        }
        return instance;
    }
}

