/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.CreateAppRequest;
import com.amazonaws.services.opsworks.model.DataSource;
import com.amazonaws.services.opsworks.model.EnvironmentVariable;
import com.amazonaws.services.opsworks.model.transform.DataSourceJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.EnvironmentVariableJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.SourceJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.SslConfigurationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateAppRequestMarshaller
implements Marshaller<Request<CreateAppRequest>, CreateAppRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateAppRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateAppRequest> marshall(CreateAppRequest createAppRequest) {
        if (createAppRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createAppRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.CreateApp");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList environmentList;
            SdkInternalMap attributesMap;
            SdkInternalList domainsList;
            SdkInternalList dataSourcesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createAppRequest.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(createAppRequest.getStackId());
            }
            if (createAppRequest.getShortname() != null) {
                jsonGenerator.writeFieldName("Shortname").writeValue(createAppRequest.getShortname());
            }
            if (createAppRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createAppRequest.getName());
            }
            if (createAppRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(createAppRequest.getDescription());
            }
            if (!(dataSourcesList = (SdkInternalList)createAppRequest.getDataSources()).isEmpty() || !dataSourcesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("DataSources");
                jsonGenerator.writeStartArray();
                for (Object dataSourcesListValue : dataSourcesList) {
                    if (dataSourcesListValue == null) continue;
                    DataSourceJsonMarshaller.getInstance().marshall((DataSource)dataSourcesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createAppRequest.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(createAppRequest.getType());
            }
            if (createAppRequest.getAppSource() != null) {
                jsonGenerator.writeFieldName("AppSource");
                SourceJsonMarshaller.getInstance().marshall(createAppRequest.getAppSource(), jsonGenerator);
            }
            if (!(domainsList = (SdkInternalList)createAppRequest.getDomains()).isEmpty() || !domainsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Domains");
                jsonGenerator.writeStartArray();
                for (Object domainsListValue : domainsList) {
                    if (domainsListValue == null) continue;
                    jsonGenerator.writeValue((String)domainsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (createAppRequest.getEnableSsl() != null) {
                jsonGenerator.writeFieldName("EnableSsl").writeValue(createAppRequest.getEnableSsl().booleanValue());
            }
            if (createAppRequest.getSslConfiguration() != null) {
                jsonGenerator.writeFieldName("SslConfiguration");
                SslConfigurationJsonMarshaller.getInstance().marshall(createAppRequest.getSslConfiguration(), jsonGenerator);
            }
            if (!(attributesMap = (SdkInternalMap)createAppRequest.getAttributes()).isEmpty() || !attributesMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Attributes");
                jsonGenerator.writeStartObject();
                for (Object attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)attributesMapValue.getKey());
                    jsonGenerator.writeValue((String)attributesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (!(environmentList = (SdkInternalList)createAppRequest.getEnvironment()).isEmpty() || !environmentList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Environment");
                jsonGenerator.writeStartArray();
                for (EnvironmentVariable environmentListValue : environmentList) {
                    if (environmentListValue == null) continue;
                    EnvironmentVariableJsonMarshaller.getInstance().marshall(environmentListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

