/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.opsworks.AWSOpsWorks;
import com.amazonaws.services.opsworks.model.DescribeAppsRequest;
import com.amazonaws.services.opsworks.model.DescribeDeploymentsRequest;
import com.amazonaws.services.opsworks.model.DescribeInstancesRequest;
import com.amazonaws.services.opsworks.waiters.DeploymentSuccessful;
import com.amazonaws.services.opsworks.waiters.DescribeAppsFunction;
import com.amazonaws.services.opsworks.waiters.DescribeDeploymentsFunction;
import com.amazonaws.services.opsworks.waiters.DescribeInstancesFunction;
import com.amazonaws.services.opsworks.waiters.InstanceOnline;
import com.amazonaws.services.opsworks.waiters.InstanceRegistered;
import com.amazonaws.services.opsworks.waiters.InstanceStopped;
import com.amazonaws.services.opsworks.waiters.InstanceTerminated;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.HttpFailureStatusAcceptor;
import com.amazonaws.waiters.HttpSuccessStatusAcceptor;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterState;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AWSOpsWorksWaiters {
    private final AWSOpsWorks client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AWSOpsWorksWaiters(AWSOpsWorks client) {
        this.client = client;
    }

    public Waiter<DescribeInstancesRequest> instanceTerminated() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceTerminated.IsTerminatedMatcher(), new InstanceTerminated.IsResourceNotFoundExceptionMatcher(), new InstanceTerminated.IsBootingMatcher(), new InstanceTerminated.IsOnlineMatcher(), new InstanceTerminated.IsPendingMatcher(), new InstanceTerminated.IsRebootingMatcher(), new InstanceTerminated.IsRequestedMatcher(), new InstanceTerminated.IsRunning_setupMatcher(), new InstanceTerminated.IsSetup_failedMatcher(), new InstanceTerminated.IsStart_failedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeAppsRequest> appExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeAppsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new HttpFailureStatusAcceptor(400, WaiterState.FAILURE)}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(1))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeInstancesRequest> instanceOnline() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceOnline.IsOnlineMatcher(), new InstanceOnline.IsSetup_failedMatcher(), new InstanceOnline.IsShutting_downMatcher(), new InstanceOnline.IsStart_failedMatcher(), new InstanceOnline.IsStoppedMatcher(), new InstanceOnline.IsStoppingMatcher(), new InstanceOnline.IsTerminatingMatcher(), new InstanceOnline.IsTerminatedMatcher(), new InstanceOnline.IsStop_failedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeDeploymentsRequest> deploymentSuccessful() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeDeploymentsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new DeploymentSuccessful.IsSuccessfulMatcher(), new DeploymentSuccessful.IsFailedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeInstancesRequest> instanceStopped() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceStopped.IsStoppedMatcher(), new InstanceStopped.IsBootingMatcher(), new InstanceStopped.IsOnlineMatcher(), new InstanceStopped.IsPendingMatcher(), new InstanceStopped.IsRebootingMatcher(), new InstanceStopped.IsRequestedMatcher(), new InstanceStopped.IsRunning_setupMatcher(), new InstanceStopped.IsSetup_failedMatcher(), new InstanceStopped.IsStart_failedMatcher(), new InstanceStopped.IsStop_failedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeInstancesRequest> instanceRegistered() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceRegistered.IsRegisteredMatcher(), new InstanceRegistered.IsSetup_failedMatcher(), new InstanceRegistered.IsShutting_downMatcher(), new InstanceRegistered.IsStoppedMatcher(), new InstanceRegistered.IsStoppingMatcher(), new InstanceRegistered.IsTerminatingMatcher(), new InstanceRegistered.IsTerminatedMatcher(), new InstanceRegistered.IsStop_failedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }
}

