/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.outposts.model.LineItemAssetInformation;
import com.amazonaws.services.outposts.model.LineItemStatus;
import com.amazonaws.services.outposts.model.ShipmentInformation;
import com.amazonaws.services.outposts.model.transform.LineItemMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LineItem
implements Serializable,
Cloneable,
StructuredPojo {
    private String catalogItemId;
    private String lineItemId;
    private Integer quantity;
    private String status;
    private ShipmentInformation shipmentInformation;
    private List<LineItemAssetInformation> assetInformationList;
    private String previousLineItemId;
    private String previousOrderId;

    public void setCatalogItemId(String catalogItemId) {
        this.catalogItemId = catalogItemId;
    }

    public String getCatalogItemId() {
        return this.catalogItemId;
    }

    public LineItem withCatalogItemId(String catalogItemId) {
        this.setCatalogItemId(catalogItemId);
        return this;
    }

    public void setLineItemId(String lineItemId) {
        this.lineItemId = lineItemId;
    }

    public String getLineItemId() {
        return this.lineItemId;
    }

    public LineItem withLineItemId(String lineItemId) {
        this.setLineItemId(lineItemId);
        return this;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public LineItem withQuantity(Integer quantity) {
        this.setQuantity(quantity);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public LineItem withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public LineItem withStatus(LineItemStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setShipmentInformation(ShipmentInformation shipmentInformation) {
        this.shipmentInformation = shipmentInformation;
    }

    public ShipmentInformation getShipmentInformation() {
        return this.shipmentInformation;
    }

    public LineItem withShipmentInformation(ShipmentInformation shipmentInformation) {
        this.setShipmentInformation(shipmentInformation);
        return this;
    }

    public List<LineItemAssetInformation> getAssetInformationList() {
        return this.assetInformationList;
    }

    public void setAssetInformationList(Collection<LineItemAssetInformation> assetInformationList) {
        if (assetInformationList == null) {
            this.assetInformationList = null;
            return;
        }
        this.assetInformationList = new ArrayList<LineItemAssetInformation>(assetInformationList);
    }

    public LineItem withAssetInformationList(LineItemAssetInformation ... assetInformationList) {
        if (this.assetInformationList == null) {
            this.setAssetInformationList(new ArrayList<LineItemAssetInformation>(assetInformationList.length));
        }
        for (LineItemAssetInformation ele : assetInformationList) {
            this.assetInformationList.add(ele);
        }
        return this;
    }

    public LineItem withAssetInformationList(Collection<LineItemAssetInformation> assetInformationList) {
        this.setAssetInformationList(assetInformationList);
        return this;
    }

    public void setPreviousLineItemId(String previousLineItemId) {
        this.previousLineItemId = previousLineItemId;
    }

    public String getPreviousLineItemId() {
        return this.previousLineItemId;
    }

    public LineItem withPreviousLineItemId(String previousLineItemId) {
        this.setPreviousLineItemId(previousLineItemId);
        return this;
    }

    public void setPreviousOrderId(String previousOrderId) {
        this.previousOrderId = previousOrderId;
    }

    public String getPreviousOrderId() {
        return this.previousOrderId;
    }

    public LineItem withPreviousOrderId(String previousOrderId) {
        this.setPreviousOrderId(previousOrderId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCatalogItemId() != null) {
            sb.append("CatalogItemId: ").append(this.getCatalogItemId()).append(",");
        }
        if (this.getLineItemId() != null) {
            sb.append("LineItemId: ").append(this.getLineItemId()).append(",");
        }
        if (this.getQuantity() != null) {
            sb.append("Quantity: ").append(this.getQuantity()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getShipmentInformation() != null) {
            sb.append("ShipmentInformation: ").append(this.getShipmentInformation()).append(",");
        }
        if (this.getAssetInformationList() != null) {
            sb.append("AssetInformationList: ").append(this.getAssetInformationList()).append(",");
        }
        if (this.getPreviousLineItemId() != null) {
            sb.append("PreviousLineItemId: ").append(this.getPreviousLineItemId()).append(",");
        }
        if (this.getPreviousOrderId() != null) {
            sb.append("PreviousOrderId: ").append(this.getPreviousOrderId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineItem)) {
            return false;
        }
        LineItem other = (LineItem)obj;
        if (other.getCatalogItemId() == null ^ this.getCatalogItemId() == null) {
            return false;
        }
        if (other.getCatalogItemId() != null && !other.getCatalogItemId().equals(this.getCatalogItemId())) {
            return false;
        }
        if (other.getLineItemId() == null ^ this.getLineItemId() == null) {
            return false;
        }
        if (other.getLineItemId() != null && !other.getLineItemId().equals(this.getLineItemId())) {
            return false;
        }
        if (other.getQuantity() == null ^ this.getQuantity() == null) {
            return false;
        }
        if (other.getQuantity() != null && !other.getQuantity().equals(this.getQuantity())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getShipmentInformation() == null ^ this.getShipmentInformation() == null) {
            return false;
        }
        if (other.getShipmentInformation() != null && !other.getShipmentInformation().equals(this.getShipmentInformation())) {
            return false;
        }
        if (other.getAssetInformationList() == null ^ this.getAssetInformationList() == null) {
            return false;
        }
        if (other.getAssetInformationList() != null && !other.getAssetInformationList().equals(this.getAssetInformationList())) {
            return false;
        }
        if (other.getPreviousLineItemId() == null ^ this.getPreviousLineItemId() == null) {
            return false;
        }
        if (other.getPreviousLineItemId() != null && !other.getPreviousLineItemId().equals(this.getPreviousLineItemId())) {
            return false;
        }
        if (other.getPreviousOrderId() == null ^ this.getPreviousOrderId() == null) {
            return false;
        }
        return other.getPreviousOrderId() == null || other.getPreviousOrderId().equals(this.getPreviousOrderId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCatalogItemId() == null ? 0 : this.getCatalogItemId().hashCode());
        hashCode = 31 * hashCode + (this.getLineItemId() == null ? 0 : this.getLineItemId().hashCode());
        hashCode = 31 * hashCode + (this.getQuantity() == null ? 0 : this.getQuantity().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getShipmentInformation() == null ? 0 : this.getShipmentInformation().hashCode());
        hashCode = 31 * hashCode + (this.getAssetInformationList() == null ? 0 : this.getAssetInformationList().hashCode());
        hashCode = 31 * hashCode + (this.getPreviousLineItemId() == null ? 0 : this.getPreviousLineItemId().hashCode());
        hashCode = 31 * hashCode + (this.getPreviousOrderId() == null ? 0 : this.getPreviousOrderId().hashCode());
        return hashCode;
    }

    public LineItem clone() {
        try {
            return (LineItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LineItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

