/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.personalize.model.DataSource;
import com.amazonaws.services.personalize.model.ImportMode;
import com.amazonaws.services.personalize.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateDatasetImportJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String jobName;
    private String datasetArn;
    private DataSource dataSource;
    private String roleArn;
    private List<Tag> tags;
    private String importMode;
    private Boolean publishAttributionMetricsToS3;

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public CreateDatasetImportJobRequest withJobName(String jobName) {
        this.setJobName(jobName);
        return this;
    }

    public void setDatasetArn(String datasetArn) {
        this.datasetArn = datasetArn;
    }

    public String getDatasetArn() {
        return this.datasetArn;
    }

    public CreateDatasetImportJobRequest withDatasetArn(String datasetArn) {
        this.setDatasetArn(datasetArn);
        return this;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public CreateDatasetImportJobRequest withDataSource(DataSource dataSource) {
        this.setDataSource(dataSource);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public CreateDatasetImportJobRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateDatasetImportJobRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateDatasetImportJobRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setImportMode(String importMode) {
        this.importMode = importMode;
    }

    public String getImportMode() {
        return this.importMode;
    }

    public CreateDatasetImportJobRequest withImportMode(String importMode) {
        this.setImportMode(importMode);
        return this;
    }

    public CreateDatasetImportJobRequest withImportMode(ImportMode importMode) {
        this.importMode = importMode.toString();
        return this;
    }

    public void setPublishAttributionMetricsToS3(Boolean publishAttributionMetricsToS3) {
        this.publishAttributionMetricsToS3 = publishAttributionMetricsToS3;
    }

    public Boolean getPublishAttributionMetricsToS3() {
        return this.publishAttributionMetricsToS3;
    }

    public CreateDatasetImportJobRequest withPublishAttributionMetricsToS3(Boolean publishAttributionMetricsToS3) {
        this.setPublishAttributionMetricsToS3(publishAttributionMetricsToS3);
        return this;
    }

    public Boolean isPublishAttributionMetricsToS3() {
        return this.publishAttributionMetricsToS3;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobName() != null) {
            sb.append("JobName: ").append(this.getJobName()).append(",");
        }
        if (this.getDatasetArn() != null) {
            sb.append("DatasetArn: ").append(this.getDatasetArn()).append(",");
        }
        if (this.getDataSource() != null) {
            sb.append("DataSource: ").append(this.getDataSource()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getImportMode() != null) {
            sb.append("ImportMode: ").append(this.getImportMode()).append(",");
        }
        if (this.getPublishAttributionMetricsToS3() != null) {
            sb.append("PublishAttributionMetricsToS3: ").append(this.getPublishAttributionMetricsToS3());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetImportJobRequest)) {
            return false;
        }
        CreateDatasetImportJobRequest other = (CreateDatasetImportJobRequest)obj;
        if (other.getJobName() == null ^ this.getJobName() == null) {
            return false;
        }
        if (other.getJobName() != null && !other.getJobName().equals(this.getJobName())) {
            return false;
        }
        if (other.getDatasetArn() == null ^ this.getDatasetArn() == null) {
            return false;
        }
        if (other.getDatasetArn() != null && !other.getDatasetArn().equals(this.getDatasetArn())) {
            return false;
        }
        if (other.getDataSource() == null ^ this.getDataSource() == null) {
            return false;
        }
        if (other.getDataSource() != null && !other.getDataSource().equals(this.getDataSource())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getImportMode() == null ^ this.getImportMode() == null) {
            return false;
        }
        if (other.getImportMode() != null && !other.getImportMode().equals(this.getImportMode())) {
            return false;
        }
        if (other.getPublishAttributionMetricsToS3() == null ^ this.getPublishAttributionMetricsToS3() == null) {
            return false;
        }
        return other.getPublishAttributionMetricsToS3() == null || other.getPublishAttributionMetricsToS3().equals(this.getPublishAttributionMetricsToS3());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobName() == null ? 0 : this.getJobName().hashCode());
        hashCode = 31 * hashCode + (this.getDatasetArn() == null ? 0 : this.getDatasetArn().hashCode());
        hashCode = 31 * hashCode + (this.getDataSource() == null ? 0 : this.getDataSource().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getImportMode() == null ? 0 : this.getImportMode().hashCode());
        hashCode = 31 * hashCode + (this.getPublishAttributionMetricsToS3() == null ? 0 : this.getPublishAttributionMetricsToS3().hashCode());
        return hashCode;
    }

    public CreateDatasetImportJobRequest clone() {
        return (CreateDatasetImportJobRequest)super.clone();
    }
}

