/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.personalize.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A truncated version of the <a
 * href="https://docs.aws.amazon.com/personalize/latest/dg/API_BatchSegmentJob.html">BatchSegmentJob</a> datatype. <a
 * href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListBatchSegmentJobs.html">ListBatchSegmentJobs</a>
 * operation returns a list of batch segment job summaries.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/BatchSegmentJobSummary" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class BatchSegmentJobSummary implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the batch segment job.
     * </p>
     */
    private String batchSegmentJobArn;
    /**
     * <p>
     * The name of the batch segment job.
     * </p>
     */
    private String jobName;
    /**
     * <p>
     * The status of the batch segment job. The status is one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * IN PROGRESS
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE FAILED
     * </p>
     * </li>
     * </ul>
     */
    private String status;
    /**
     * <p>
     * The time at which the batch segment job was created.
     * </p>
     */
    private java.util.Date creationDateTime;
    /**
     * <p>
     * The time at which the batch segment job was last updated.
     * </p>
     */
    private java.util.Date lastUpdatedDateTime;
    /**
     * <p>
     * If the batch segment job failed, the reason for the failure.
     * </p>
     */
    private String failureReason;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch segments.
     * </p>
     */
    private String solutionVersionArn;

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the batch segment job.
     * </p>
     * 
     * @param batchSegmentJobArn
     *        The Amazon Resource Name (ARN) of the batch segment job.
     */

    public void setBatchSegmentJobArn(String batchSegmentJobArn) {
        this.batchSegmentJobArn = batchSegmentJobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the batch segment job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the batch segment job.
     */

    public String getBatchSegmentJobArn() {
        return this.batchSegmentJobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the batch segment job.
     * </p>
     * 
     * @param batchSegmentJobArn
     *        The Amazon Resource Name (ARN) of the batch segment job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchSegmentJobSummary withBatchSegmentJobArn(String batchSegmentJobArn) {
        setBatchSegmentJobArn(batchSegmentJobArn);
        return this;
    }

    /**
     * <p>
     * The name of the batch segment job.
     * </p>
     * 
     * @param jobName
     *        The name of the batch segment job.
     */

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    /**
     * <p>
     * The name of the batch segment job.
     * </p>
     * 
     * @return The name of the batch segment job.
     */

    public String getJobName() {
        return this.jobName;
    }

    /**
     * <p>
     * The name of the batch segment job.
     * </p>
     * 
     * @param jobName
     *        The name of the batch segment job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchSegmentJobSummary withJobName(String jobName) {
        setJobName(jobName);
        return this;
    }

    /**
     * <p>
     * The status of the batch segment job. The status is one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * IN PROGRESS
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE FAILED
     * </p>
     * </li>
     * </ul>
     * 
     * @param status
     *        The status of the batch segment job. The status is one of the following values:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        PENDING
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        IN PROGRESS
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        ACTIVE
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        CREATE FAILED
     *        </p>
     *        </li>
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The status of the batch segment job. The status is one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * IN PROGRESS
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE FAILED
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the batch segment job. The status is one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IN PROGRESS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACTIVE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE FAILED
     *         </p>
     *         </li>
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The status of the batch segment job. The status is one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * IN PROGRESS
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE FAILED
     * </p>
     * </li>
     * </ul>
     * 
     * @param status
     *        The status of the batch segment job. The status is one of the following values:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        PENDING
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        IN PROGRESS
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        ACTIVE
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        CREATE FAILED
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchSegmentJobSummary withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * The time at which the batch segment job was created.
     * </p>
     * 
     * @param creationDateTime
     *        The time at which the batch segment job was created.
     */

    public void setCreationDateTime(java.util.Date creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    /**
     * <p>
     * The time at which the batch segment job was created.
     * </p>
     * 
     * @return The time at which the batch segment job was created.
     */

    public java.util.Date getCreationDateTime() {
        return this.creationDateTime;
    }

    /**
     * <p>
     * The time at which the batch segment job was created.
     * </p>
     * 
     * @param creationDateTime
     *        The time at which the batch segment job was created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchSegmentJobSummary withCreationDateTime(java.util.Date creationDateTime) {
        setCreationDateTime(creationDateTime);
        return this;
    }

    /**
     * <p>
     * The time at which the batch segment job was last updated.
     * </p>
     * 
     * @param lastUpdatedDateTime
     *        The time at which the batch segment job was last updated.
     */

    public void setLastUpdatedDateTime(java.util.Date lastUpdatedDateTime) {
        this.lastUpdatedDateTime = lastUpdatedDateTime;
    }

    /**
     * <p>
     * The time at which the batch segment job was last updated.
     * </p>
     * 
     * @return The time at which the batch segment job was last updated.
     */

    public java.util.Date getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The time at which the batch segment job was last updated.
     * </p>
     * 
     * @param lastUpdatedDateTime
     *        The time at which the batch segment job was last updated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchSegmentJobSummary withLastUpdatedDateTime(java.util.Date lastUpdatedDateTime) {
        setLastUpdatedDateTime(lastUpdatedDateTime);
        return this;
    }

    /**
     * <p>
     * If the batch segment job failed, the reason for the failure.
     * </p>
     * 
     * @param failureReason
     *        If the batch segment job failed, the reason for the failure.
     */

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    /**
     * <p>
     * If the batch segment job failed, the reason for the failure.
     * </p>
     * 
     * @return If the batch segment job failed, the reason for the failure.
     */

    public String getFailureReason() {
        return this.failureReason;
    }

    /**
     * <p>
     * If the batch segment job failed, the reason for the failure.
     * </p>
     * 
     * @param failureReason
     *        If the batch segment job failed, the reason for the failure.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchSegmentJobSummary withFailureReason(String failureReason) {
        setFailureReason(failureReason);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch segments.
     * </p>
     * 
     * @param solutionVersionArn
     *        The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch
     *        segments.
     */

    public void setSolutionVersionArn(String solutionVersionArn) {
        this.solutionVersionArn = solutionVersionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch segments.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch
     *         segments.
     */

    public String getSolutionVersionArn() {
        return this.solutionVersionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch segments.
     * </p>
     * 
     * @param solutionVersionArn
     *        The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch
     *        segments.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchSegmentJobSummary withSolutionVersionArn(String solutionVersionArn) {
        setSolutionVersionArn(solutionVersionArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getBatchSegmentJobArn() != null)
            sb.append("BatchSegmentJobArn: ").append(getBatchSegmentJobArn()).append(",");
        if (getJobName() != null)
            sb.append("JobName: ").append(getJobName()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getCreationDateTime() != null)
            sb.append("CreationDateTime: ").append(getCreationDateTime()).append(",");
        if (getLastUpdatedDateTime() != null)
            sb.append("LastUpdatedDateTime: ").append(getLastUpdatedDateTime()).append(",");
        if (getFailureReason() != null)
            sb.append("FailureReason: ").append(getFailureReason()).append(",");
        if (getSolutionVersionArn() != null)
            sb.append("SolutionVersionArn: ").append(getSolutionVersionArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof BatchSegmentJobSummary == false)
            return false;
        BatchSegmentJobSummary other = (BatchSegmentJobSummary) obj;
        if (other.getBatchSegmentJobArn() == null ^ this.getBatchSegmentJobArn() == null)
            return false;
        if (other.getBatchSegmentJobArn() != null && other.getBatchSegmentJobArn().equals(this.getBatchSegmentJobArn()) == false)
            return false;
        if (other.getJobName() == null ^ this.getJobName() == null)
            return false;
        if (other.getJobName() != null && other.getJobName().equals(this.getJobName()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getCreationDateTime() == null ^ this.getCreationDateTime() == null)
            return false;
        if (other.getCreationDateTime() != null && other.getCreationDateTime().equals(this.getCreationDateTime()) == false)
            return false;
        if (other.getLastUpdatedDateTime() == null ^ this.getLastUpdatedDateTime() == null)
            return false;
        if (other.getLastUpdatedDateTime() != null && other.getLastUpdatedDateTime().equals(this.getLastUpdatedDateTime()) == false)
            return false;
        if (other.getFailureReason() == null ^ this.getFailureReason() == null)
            return false;
        if (other.getFailureReason() != null && other.getFailureReason().equals(this.getFailureReason()) == false)
            return false;
        if (other.getSolutionVersionArn() == null ^ this.getSolutionVersionArn() == null)
            return false;
        if (other.getSolutionVersionArn() != null && other.getSolutionVersionArn().equals(this.getSolutionVersionArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getBatchSegmentJobArn() == null) ? 0 : getBatchSegmentJobArn().hashCode());
        hashCode = prime * hashCode + ((getJobName() == null) ? 0 : getJobName().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getCreationDateTime() == null) ? 0 : getCreationDateTime().hashCode());
        hashCode = prime * hashCode + ((getLastUpdatedDateTime() == null) ? 0 : getLastUpdatedDateTime().hashCode());
        hashCode = prime * hashCode + ((getFailureReason() == null) ? 0 : getFailureReason().hashCode());
        hashCode = prime * hashCode + ((getSolutionVersionArn() == null) ? 0 : getSolutionVersionArn().hashCode());
        return hashCode;
    }

    @Override
    public BatchSegmentJobSummary clone() {
        try {
            return (BatchSegmentJobSummary) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.personalize.model.transform.BatchSegmentJobSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
