/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pi.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pi.model.transform.DimensionKeyDescriptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DimensionKeyDescription
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> dimensions;
    private Double total;
    private Map<String, Double> additionalMetrics;
    private List<Double> partitions;

    public Map<String, String> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Map<String, String> dimensions) {
        this.dimensions = dimensions;
    }

    public DimensionKeyDescription withDimensions(Map<String, String> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public DimensionKeyDescription addDimensionsEntry(String key, String value) {
        if (null == this.dimensions) {
            this.dimensions = new HashMap<String, String>();
        }
        if (this.dimensions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.dimensions.put(key, value);
        return this;
    }

    public DimensionKeyDescription clearDimensionsEntries() {
        this.dimensions = null;
        return this;
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    public Double getTotal() {
        return this.total;
    }

    public DimensionKeyDescription withTotal(Double total) {
        this.setTotal(total);
        return this;
    }

    public Map<String, Double> getAdditionalMetrics() {
        return this.additionalMetrics;
    }

    public void setAdditionalMetrics(Map<String, Double> additionalMetrics) {
        this.additionalMetrics = additionalMetrics;
    }

    public DimensionKeyDescription withAdditionalMetrics(Map<String, Double> additionalMetrics) {
        this.setAdditionalMetrics(additionalMetrics);
        return this;
    }

    public DimensionKeyDescription addAdditionalMetricsEntry(String key, Double value) {
        if (null == this.additionalMetrics) {
            this.additionalMetrics = new HashMap<String, Double>();
        }
        if (this.additionalMetrics.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.additionalMetrics.put(key, value);
        return this;
    }

    public DimensionKeyDescription clearAdditionalMetricsEntries() {
        this.additionalMetrics = null;
        return this;
    }

    public List<Double> getPartitions() {
        return this.partitions;
    }

    public void setPartitions(Collection<Double> partitions) {
        if (partitions == null) {
            this.partitions = null;
            return;
        }
        this.partitions = new ArrayList<Double>(partitions);
    }

    public DimensionKeyDescription withPartitions(Double ... partitions) {
        if (this.partitions == null) {
            this.setPartitions(new ArrayList<Double>(partitions.length));
        }
        for (Double ele : partitions) {
            this.partitions.add(ele);
        }
        return this;
    }

    public DimensionKeyDescription withPartitions(Collection<Double> partitions) {
        this.setPartitions(partitions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions()).append(",");
        }
        if (this.getTotal() != null) {
            sb.append("Total: ").append(this.getTotal()).append(",");
        }
        if (this.getAdditionalMetrics() != null) {
            sb.append("AdditionalMetrics: ").append(this.getAdditionalMetrics()).append(",");
        }
        if (this.getPartitions() != null) {
            sb.append("Partitions: ").append(this.getPartitions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionKeyDescription)) {
            return false;
        }
        DimensionKeyDescription other = (DimensionKeyDescription)obj;
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getTotal() == null ^ this.getTotal() == null) {
            return false;
        }
        if (other.getTotal() != null && !other.getTotal().equals(this.getTotal())) {
            return false;
        }
        if (other.getAdditionalMetrics() == null ^ this.getAdditionalMetrics() == null) {
            return false;
        }
        if (other.getAdditionalMetrics() != null && !other.getAdditionalMetrics().equals(this.getAdditionalMetrics())) {
            return false;
        }
        if (other.getPartitions() == null ^ this.getPartitions() == null) {
            return false;
        }
        return other.getPartitions() == null || other.getPartitions().equals(this.getPartitions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getTotal() == null ? 0 : this.getTotal().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalMetrics() == null ? 0 : this.getAdditionalMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getPartitions() == null ? 0 : this.getPartitions().hashCode());
        return hashCode;
    }

    public DimensionKeyDescription clone() {
        try {
            return (DimensionKeyDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DimensionKeyDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

