/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pipes.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.pipes.model.Pipe;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListPipesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<Pipe> pipes;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListPipesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<Pipe> getPipes() {
        return this.pipes;
    }

    public void setPipes(Collection<Pipe> pipes) {
        if (pipes == null) {
            this.pipes = null;
            return;
        }
        this.pipes = new ArrayList<Pipe>(pipes);
    }

    public ListPipesResult withPipes(Pipe ... pipes) {
        if (this.pipes == null) {
            this.setPipes(new ArrayList<Pipe>(pipes.length));
        }
        for (Pipe ele : pipes) {
            this.pipes.add(ele);
        }
        return this;
    }

    public ListPipesResult withPipes(Collection<Pipe> pipes) {
        this.setPipes(pipes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getPipes() != null) {
            sb.append("Pipes: ").append(this.getPipes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipesResult)) {
            return false;
        }
        ListPipesResult other = (ListPipesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getPipes() == null ^ this.getPipes() == null) {
            return false;
        }
        return other.getPipes() == null || other.getPipes().equals(this.getPipes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getPipes() == null ? 0 : this.getPipes().hashCode());
        return hashCode;
    }

    public ListPipesResult clone() {
        try {
            return (ListPipesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

