/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pipes.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pipes.model.EcsContainerOverride;
import com.amazonaws.services.pipes.model.EcsEphemeralStorage;
import com.amazonaws.services.pipes.model.EcsInferenceAcceleratorOverride;
import com.amazonaws.services.pipes.model.transform.EcsTaskOverrideMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EcsTaskOverride
implements Serializable,
Cloneable,
StructuredPojo {
    private List<EcsContainerOverride> containerOverrides;
    private String cpu;
    private EcsEphemeralStorage ephemeralStorage;
    private String executionRoleArn;
    private List<EcsInferenceAcceleratorOverride> inferenceAcceleratorOverrides;
    private String memory;
    private String taskRoleArn;

    public List<EcsContainerOverride> getContainerOverrides() {
        return this.containerOverrides;
    }

    public void setContainerOverrides(Collection<EcsContainerOverride> containerOverrides) {
        if (containerOverrides == null) {
            this.containerOverrides = null;
            return;
        }
        this.containerOverrides = new ArrayList<EcsContainerOverride>(containerOverrides);
    }

    public EcsTaskOverride withContainerOverrides(EcsContainerOverride ... containerOverrides) {
        if (this.containerOverrides == null) {
            this.setContainerOverrides(new ArrayList<EcsContainerOverride>(containerOverrides.length));
        }
        for (EcsContainerOverride ele : containerOverrides) {
            this.containerOverrides.add(ele);
        }
        return this;
    }

    public EcsTaskOverride withContainerOverrides(Collection<EcsContainerOverride> containerOverrides) {
        this.setContainerOverrides(containerOverrides);
        return this;
    }

    public void setCpu(String cpu) {
        this.cpu = cpu;
    }

    public String getCpu() {
        return this.cpu;
    }

    public EcsTaskOverride withCpu(String cpu) {
        this.setCpu(cpu);
        return this;
    }

    public void setEphemeralStorage(EcsEphemeralStorage ephemeralStorage) {
        this.ephemeralStorage = ephemeralStorage;
    }

    public EcsEphemeralStorage getEphemeralStorage() {
        return this.ephemeralStorage;
    }

    public EcsTaskOverride withEphemeralStorage(EcsEphemeralStorage ephemeralStorage) {
        this.setEphemeralStorage(ephemeralStorage);
        return this;
    }

    public void setExecutionRoleArn(String executionRoleArn) {
        this.executionRoleArn = executionRoleArn;
    }

    public String getExecutionRoleArn() {
        return this.executionRoleArn;
    }

    public EcsTaskOverride withExecutionRoleArn(String executionRoleArn) {
        this.setExecutionRoleArn(executionRoleArn);
        return this;
    }

    public List<EcsInferenceAcceleratorOverride> getInferenceAcceleratorOverrides() {
        return this.inferenceAcceleratorOverrides;
    }

    public void setInferenceAcceleratorOverrides(Collection<EcsInferenceAcceleratorOverride> inferenceAcceleratorOverrides) {
        if (inferenceAcceleratorOverrides == null) {
            this.inferenceAcceleratorOverrides = null;
            return;
        }
        this.inferenceAcceleratorOverrides = new ArrayList<EcsInferenceAcceleratorOverride>(inferenceAcceleratorOverrides);
    }

    public EcsTaskOverride withInferenceAcceleratorOverrides(EcsInferenceAcceleratorOverride ... inferenceAcceleratorOverrides) {
        if (this.inferenceAcceleratorOverrides == null) {
            this.setInferenceAcceleratorOverrides(new ArrayList<EcsInferenceAcceleratorOverride>(inferenceAcceleratorOverrides.length));
        }
        for (EcsInferenceAcceleratorOverride ele : inferenceAcceleratorOverrides) {
            this.inferenceAcceleratorOverrides.add(ele);
        }
        return this;
    }

    public EcsTaskOverride withInferenceAcceleratorOverrides(Collection<EcsInferenceAcceleratorOverride> inferenceAcceleratorOverrides) {
        this.setInferenceAcceleratorOverrides(inferenceAcceleratorOverrides);
        return this;
    }

    public void setMemory(String memory) {
        this.memory = memory;
    }

    public String getMemory() {
        return this.memory;
    }

    public EcsTaskOverride withMemory(String memory) {
        this.setMemory(memory);
        return this;
    }

    public void setTaskRoleArn(String taskRoleArn) {
        this.taskRoleArn = taskRoleArn;
    }

    public String getTaskRoleArn() {
        return this.taskRoleArn;
    }

    public EcsTaskOverride withTaskRoleArn(String taskRoleArn) {
        this.setTaskRoleArn(taskRoleArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainerOverrides() != null) {
            sb.append("ContainerOverrides: ").append(this.getContainerOverrides()).append(",");
        }
        if (this.getCpu() != null) {
            sb.append("Cpu: ").append(this.getCpu()).append(",");
        }
        if (this.getEphemeralStorage() != null) {
            sb.append("EphemeralStorage: ").append(this.getEphemeralStorage()).append(",");
        }
        if (this.getExecutionRoleArn() != null) {
            sb.append("ExecutionRoleArn: ").append(this.getExecutionRoleArn()).append(",");
        }
        if (this.getInferenceAcceleratorOverrides() != null) {
            sb.append("InferenceAcceleratorOverrides: ").append(this.getInferenceAcceleratorOverrides()).append(",");
        }
        if (this.getMemory() != null) {
            sb.append("Memory: ").append(this.getMemory()).append(",");
        }
        if (this.getTaskRoleArn() != null) {
            sb.append("TaskRoleArn: ").append(this.getTaskRoleArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsTaskOverride)) {
            return false;
        }
        EcsTaskOverride other = (EcsTaskOverride)obj;
        if (other.getContainerOverrides() == null ^ this.getContainerOverrides() == null) {
            return false;
        }
        if (other.getContainerOverrides() != null && !other.getContainerOverrides().equals(this.getContainerOverrides())) {
            return false;
        }
        if (other.getCpu() == null ^ this.getCpu() == null) {
            return false;
        }
        if (other.getCpu() != null && !other.getCpu().equals(this.getCpu())) {
            return false;
        }
        if (other.getEphemeralStorage() == null ^ this.getEphemeralStorage() == null) {
            return false;
        }
        if (other.getEphemeralStorage() != null && !other.getEphemeralStorage().equals(this.getEphemeralStorage())) {
            return false;
        }
        if (other.getExecutionRoleArn() == null ^ this.getExecutionRoleArn() == null) {
            return false;
        }
        if (other.getExecutionRoleArn() != null && !other.getExecutionRoleArn().equals(this.getExecutionRoleArn())) {
            return false;
        }
        if (other.getInferenceAcceleratorOverrides() == null ^ this.getInferenceAcceleratorOverrides() == null) {
            return false;
        }
        if (other.getInferenceAcceleratorOverrides() != null && !other.getInferenceAcceleratorOverrides().equals(this.getInferenceAcceleratorOverrides())) {
            return false;
        }
        if (other.getMemory() == null ^ this.getMemory() == null) {
            return false;
        }
        if (other.getMemory() != null && !other.getMemory().equals(this.getMemory())) {
            return false;
        }
        if (other.getTaskRoleArn() == null ^ this.getTaskRoleArn() == null) {
            return false;
        }
        return other.getTaskRoleArn() == null || other.getTaskRoleArn().equals(this.getTaskRoleArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainerOverrides() == null ? 0 : this.getContainerOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getCpu() == null ? 0 : this.getCpu().hashCode());
        hashCode = 31 * hashCode + (this.getEphemeralStorage() == null ? 0 : this.getEphemeralStorage().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionRoleArn() == null ? 0 : this.getExecutionRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getInferenceAcceleratorOverrides() == null ? 0 : this.getInferenceAcceleratorOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getMemory() == null ? 0 : this.getMemory().hashCode());
        hashCode = 31 * hashCode + (this.getTaskRoleArn() == null ? 0 : this.getTaskRoleArn().hashCode());
        return hashCode;
    }

    public EcsTaskOverride clone() {
        try {
            return (EcsTaskOverride)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EcsTaskOverrideMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

