/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pricing.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetProductsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String formatVersion;
    private List<String> priceList;
    private String nextToken;

    public void setFormatVersion(String formatVersion) {
        this.formatVersion = formatVersion;
    }

    public String getFormatVersion() {
        return this.formatVersion;
    }

    public GetProductsResult withFormatVersion(String formatVersion) {
        this.setFormatVersion(formatVersion);
        return this;
    }

    public List<String> getPriceList() {
        return this.priceList;
    }

    public void setPriceList(Collection<String> priceList) {
        if (priceList == null) {
            this.priceList = null;
            return;
        }
        this.priceList = new ArrayList<String>(priceList);
    }

    public GetProductsResult withPriceList(String ... priceList) {
        if (this.priceList == null) {
            this.setPriceList(new ArrayList<String>(priceList.length));
        }
        for (String ele : priceList) {
            this.priceList.add(ele);
        }
        return this;
    }

    public GetProductsResult withPriceList(Collection<String> priceList) {
        this.setPriceList(priceList);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetProductsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFormatVersion() != null) {
            sb.append("FormatVersion: ").append(this.getFormatVersion()).append(",");
        }
        if (this.getPriceList() != null) {
            sb.append("PriceList: ").append(this.getPriceList()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProductsResult)) {
            return false;
        }
        GetProductsResult other = (GetProductsResult)obj;
        if (other.getFormatVersion() == null ^ this.getFormatVersion() == null) {
            return false;
        }
        if (other.getFormatVersion() != null && !other.getFormatVersion().equals(this.getFormatVersion())) {
            return false;
        }
        if (other.getPriceList() == null ^ this.getPriceList() == null) {
            return false;
        }
        if (other.getPriceList() != null && !other.getPriceList().equals(this.getPriceList())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFormatVersion() == null ? 0 : this.getFormatVersion().hashCode());
        hashCode = 31 * hashCode + (this.getPriceList() == null ? 0 : this.getPriceList().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public GetProductsResult clone() {
        try {
            return (GetProductsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

