/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.qconnect.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Summary of the data.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DataSummary" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DataSummary implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Details about the data.
     * </p>
     */
    private DataDetails details;
    /**
     * <p>
     * Reference information about the content.
     * </p>
     */
    private DataReference reference;

    /**
     * <p>
     * Details about the data.
     * </p>
     * 
     * @param details
     *        Details about the data.
     */

    public void setDetails(DataDetails details) {
        this.details = details;
    }

    /**
     * <p>
     * Details about the data.
     * </p>
     * 
     * @return Details about the data.
     */

    public DataDetails getDetails() {
        return this.details;
    }

    /**
     * <p>
     * Details about the data.
     * </p>
     * 
     * @param details
     *        Details about the data.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DataSummary withDetails(DataDetails details) {
        setDetails(details);
        return this;
    }

    /**
     * <p>
     * Reference information about the content.
     * </p>
     * 
     * @param reference
     *        Reference information about the content.
     */

    public void setReference(DataReference reference) {
        this.reference = reference;
    }

    /**
     * <p>
     * Reference information about the content.
     * </p>
     * 
     * @return Reference information about the content.
     */

    public DataReference getReference() {
        return this.reference;
    }

    /**
     * <p>
     * Reference information about the content.
     * </p>
     * 
     * @param reference
     *        Reference information about the content.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DataSummary withReference(DataReference reference) {
        setReference(reference);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDetails() != null)
            sb.append("Details: ").append(getDetails()).append(",");
        if (getReference() != null)
            sb.append("Reference: ").append(getReference());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DataSummary == false)
            return false;
        DataSummary other = (DataSummary) obj;
        if (other.getDetails() == null ^ this.getDetails() == null)
            return false;
        if (other.getDetails() != null && other.getDetails().equals(this.getDetails()) == false)
            return false;
        if (other.getReference() == null ^ this.getReference() == null)
            return false;
        if (other.getReference() != null && other.getReference().equals(this.getReference()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDetails() == null) ? 0 : getDetails().hashCode());
        hashCode = prime * hashCode + ((getReference() == null) ? 0 : getReference().hashCode());
        return hashCode;
    }

    @Override
    public DataSummary clone() {
        try {
            return (DataSummary) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.qconnect.model.transform.DataSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
