/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qldb;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.qldb.AmazonQLDBAsync;
import com.amazonaws.services.qldb.AmazonQLDBAsyncClientBuilder;
import com.amazonaws.services.qldb.AmazonQLDBClient;
import com.amazonaws.services.qldb.model.CreateLedgerRequest;
import com.amazonaws.services.qldb.model.CreateLedgerResult;
import com.amazonaws.services.qldb.model.DeleteLedgerRequest;
import com.amazonaws.services.qldb.model.DeleteLedgerResult;
import com.amazonaws.services.qldb.model.DescribeJournalS3ExportRequest;
import com.amazonaws.services.qldb.model.DescribeJournalS3ExportResult;
import com.amazonaws.services.qldb.model.DescribeLedgerRequest;
import com.amazonaws.services.qldb.model.DescribeLedgerResult;
import com.amazonaws.services.qldb.model.ExportJournalToS3Request;
import com.amazonaws.services.qldb.model.ExportJournalToS3Result;
import com.amazonaws.services.qldb.model.GetBlockRequest;
import com.amazonaws.services.qldb.model.GetBlockResult;
import com.amazonaws.services.qldb.model.GetDigestRequest;
import com.amazonaws.services.qldb.model.GetDigestResult;
import com.amazonaws.services.qldb.model.GetRevisionRequest;
import com.amazonaws.services.qldb.model.GetRevisionResult;
import com.amazonaws.services.qldb.model.ListJournalS3ExportsForLedgerRequest;
import com.amazonaws.services.qldb.model.ListJournalS3ExportsForLedgerResult;
import com.amazonaws.services.qldb.model.ListJournalS3ExportsRequest;
import com.amazonaws.services.qldb.model.ListJournalS3ExportsResult;
import com.amazonaws.services.qldb.model.ListLedgersRequest;
import com.amazonaws.services.qldb.model.ListLedgersResult;
import com.amazonaws.services.qldb.model.ListTagsForResourceRequest;
import com.amazonaws.services.qldb.model.ListTagsForResourceResult;
import com.amazonaws.services.qldb.model.TagResourceRequest;
import com.amazonaws.services.qldb.model.TagResourceResult;
import com.amazonaws.services.qldb.model.UntagResourceRequest;
import com.amazonaws.services.qldb.model.UntagResourceResult;
import com.amazonaws.services.qldb.model.UpdateLedgerRequest;
import com.amazonaws.services.qldb.model.UpdateLedgerResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonQLDBAsyncClient
extends AmazonQLDBClient
implements AmazonQLDBAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonQLDBAsyncClientBuilder asyncBuilder() {
        return AmazonQLDBAsyncClientBuilder.standard();
    }

    AmazonQLDBAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateLedgerResult> createLedgerAsync(CreateLedgerRequest request) {
        return this.createLedgerAsync(request, null);
    }

    @Override
    public Future<CreateLedgerResult> createLedgerAsync(CreateLedgerRequest request, final AsyncHandler<CreateLedgerRequest, CreateLedgerResult> asyncHandler) {
        final CreateLedgerRequest finalRequest = (CreateLedgerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateLedgerResult>(){

            @Override
            public CreateLedgerResult call() throws Exception {
                CreateLedgerResult result = null;
                try {
                    result = AmazonQLDBAsyncClient.this.executeCreateLedger(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLedgerResult> deleteLedgerAsync(DeleteLedgerRequest request) {
        return this.deleteLedgerAsync(request, null);
    }

    @Override
    public Future<DeleteLedgerResult> deleteLedgerAsync(DeleteLedgerRequest request, final AsyncHandler<DeleteLedgerRequest, DeleteLedgerResult> asyncHandler) {
        final DeleteLedgerRequest finalRequest = (DeleteLedgerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteLedgerResult>(){

            @Override
            public DeleteLedgerResult call() throws Exception {
                DeleteLedgerResult result = null;
                try {
                    result = AmazonQLDBAsyncClient.this.executeDeleteLedger(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeJournalS3ExportResult> describeJournalS3ExportAsync(DescribeJournalS3ExportRequest request) {
        return this.describeJournalS3ExportAsync(request, null);
    }

    @Override
    public Future<DescribeJournalS3ExportResult> describeJournalS3ExportAsync(DescribeJournalS3ExportRequest request, final AsyncHandler<DescribeJournalS3ExportRequest, DescribeJournalS3ExportResult> asyncHandler) {
        final DescribeJournalS3ExportRequest finalRequest = (DescribeJournalS3ExportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeJournalS3ExportResult>(){

            @Override
            public DescribeJournalS3ExportResult call() throws Exception {
                DescribeJournalS3ExportResult result = null;
                try {
                    result = AmazonQLDBAsyncClient.this.executeDescribeJournalS3Export(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLedgerResult> describeLedgerAsync(DescribeLedgerRequest request) {
        return this.describeLedgerAsync(request, null);
    }

    @Override
    public Future<DescribeLedgerResult> describeLedgerAsync(DescribeLedgerRequest request, final AsyncHandler<DescribeLedgerRequest, DescribeLedgerResult> asyncHandler) {
        final DescribeLedgerRequest finalRequest = (DescribeLedgerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeLedgerResult>(){

            @Override
            public DescribeLedgerResult call() throws Exception {
                DescribeLedgerResult result = null;
                try {
                    result = AmazonQLDBAsyncClient.this.executeDescribeLedger(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExportJournalToS3Result> exportJournalToS3Async(ExportJournalToS3Request request) {
        return this.exportJournalToS3Async(request, null);
    }

    @Override
    public Future<ExportJournalToS3Result> exportJournalToS3Async(ExportJournalToS3Request request, final AsyncHandler<ExportJournalToS3Request, ExportJournalToS3Result> asyncHandler) {
        final ExportJournalToS3Request finalRequest = (ExportJournalToS3Request)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExportJournalToS3Result>(){

            @Override
            public ExportJournalToS3Result call() throws Exception {
                ExportJournalToS3Result result = null;
                try {
                    result = AmazonQLDBAsyncClient.this.executeExportJournalToS3(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBlockResult> getBlockAsync(GetBlockRequest request) {
        return this.getBlockAsync(request, null);
    }

    @Override
    public Future<GetBlockResult> getBlockAsync(GetBlockRequest request, final AsyncHandler<GetBlockRequest, GetBlockResult> asyncHandler) {
        final GetBlockRequest finalRequest = (GetBlockRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetBlockResult>(){

            @Override
            public GetBlockResult call() throws Exception {
                GetBlockResult result = null;
                try {
                    result = AmazonQLDBAsyncClient.this.executeGetBlock(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDigestResult> getDigestAsync(GetDigestRequest request) {
        return this.getDigestAsync(request, null);
    }

    @Override
    public Future<GetDigestResult> getDigestAsync(GetDigestRequest request, final AsyncHandler<GetDigestRequest, GetDigestResult> asyncHandler) {
        final GetDigestRequest finalRequest = (GetDigestRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDigestResult>(){

            @Override
            public GetDigestResult call() throws Exception {
                GetDigestResult result = null;
                try {
                    result = AmazonQLDBAsyncClient.this.executeGetDigest(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRevisionResult> getRevisionAsync(GetRevisionRequest request) {
        return this.getRevisionAsync(request, null);
    }

    @Override
    public Future<GetRevisionResult> getRevisionAsync(GetRevisionRequest request, final AsyncHandler<GetRevisionRequest, GetRevisionResult> asyncHandler) {
        final GetRevisionRequest finalRequest = (GetRevisionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRevisionResult>(){

            @Override
            public GetRevisionResult call() throws Exception {
                GetRevisionResult result = null;
                try {
                    result = AmazonQLDBAsyncClient.this.executeGetRevision(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJournalS3ExportsResult> listJournalS3ExportsAsync(ListJournalS3ExportsRequest request) {
        return this.listJournalS3ExportsAsync(request, null);
    }

    @Override
    public Future<ListJournalS3ExportsResult> listJournalS3ExportsAsync(ListJournalS3ExportsRequest request, final AsyncHandler<ListJournalS3ExportsRequest, ListJournalS3ExportsResult> asyncHandler) {
        final ListJournalS3ExportsRequest finalRequest = (ListJournalS3ExportsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListJournalS3ExportsResult>(){

            @Override
            public ListJournalS3ExportsResult call() throws Exception {
                ListJournalS3ExportsResult result = null;
                try {
                    result = AmazonQLDBAsyncClient.this.executeListJournalS3Exports(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJournalS3ExportsForLedgerResult> listJournalS3ExportsForLedgerAsync(ListJournalS3ExportsForLedgerRequest request) {
        return this.listJournalS3ExportsForLedgerAsync(request, null);
    }

    @Override
    public Future<ListJournalS3ExportsForLedgerResult> listJournalS3ExportsForLedgerAsync(ListJournalS3ExportsForLedgerRequest request, final AsyncHandler<ListJournalS3ExportsForLedgerRequest, ListJournalS3ExportsForLedgerResult> asyncHandler) {
        final ListJournalS3ExportsForLedgerRequest finalRequest = (ListJournalS3ExportsForLedgerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListJournalS3ExportsForLedgerResult>(){

            @Override
            public ListJournalS3ExportsForLedgerResult call() throws Exception {
                ListJournalS3ExportsForLedgerResult result = null;
                try {
                    result = AmazonQLDBAsyncClient.this.executeListJournalS3ExportsForLedger(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLedgersResult> listLedgersAsync(ListLedgersRequest request) {
        return this.listLedgersAsync(request, null);
    }

    @Override
    public Future<ListLedgersResult> listLedgersAsync(ListLedgersRequest request, final AsyncHandler<ListLedgersRequest, ListLedgersResult> asyncHandler) {
        final ListLedgersRequest finalRequest = (ListLedgersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListLedgersResult>(){

            @Override
            public ListLedgersResult call() throws Exception {
                ListLedgersResult result = null;
                try {
                    result = AmazonQLDBAsyncClient.this.executeListLedgers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonQLDBAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonQLDBAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonQLDBAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateLedgerResult> updateLedgerAsync(UpdateLedgerRequest request) {
        return this.updateLedgerAsync(request, null);
    }

    @Override
    public Future<UpdateLedgerResult> updateLedgerAsync(UpdateLedgerRequest request, final AsyncHandler<UpdateLedgerRequest, UpdateLedgerResult> asyncHandler) {
        final UpdateLedgerRequest finalRequest = (UpdateLedgerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateLedgerResult>(){

            @Override
            public UpdateLedgerResult call() throws Exception {
                UpdateLedgerResult result = null;
                try {
                    result = AmazonQLDBAsyncClient.this.executeUpdateLedger(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

