/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qldb.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.qldb.model.S3ObjectEncryptionType;
import com.amazonaws.services.qldb.model.transform.S3EncryptionConfigurationMarshaller;
import java.io.Serializable;

public class S3EncryptionConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String objectEncryptionType;
    private String kmsKeyArn;

    public void setObjectEncryptionType(String objectEncryptionType) {
        this.objectEncryptionType = objectEncryptionType;
    }

    public String getObjectEncryptionType() {
        return this.objectEncryptionType;
    }

    public S3EncryptionConfiguration withObjectEncryptionType(String objectEncryptionType) {
        this.setObjectEncryptionType(objectEncryptionType);
        return this;
    }

    public S3EncryptionConfiguration withObjectEncryptionType(S3ObjectEncryptionType objectEncryptionType) {
        this.objectEncryptionType = objectEncryptionType.toString();
        return this;
    }

    public void setKmsKeyArn(String kmsKeyArn) {
        this.kmsKeyArn = kmsKeyArn;
    }

    public String getKmsKeyArn() {
        return this.kmsKeyArn;
    }

    public S3EncryptionConfiguration withKmsKeyArn(String kmsKeyArn) {
        this.setKmsKeyArn(kmsKeyArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getObjectEncryptionType() != null) {
            sb.append("ObjectEncryptionType: ").append(this.getObjectEncryptionType()).append(",");
        }
        if (this.getKmsKeyArn() != null) {
            sb.append("KmsKeyArn: ").append(this.getKmsKeyArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3EncryptionConfiguration)) {
            return false;
        }
        S3EncryptionConfiguration other = (S3EncryptionConfiguration)obj;
        if (other.getObjectEncryptionType() == null ^ this.getObjectEncryptionType() == null) {
            return false;
        }
        if (other.getObjectEncryptionType() != null && !other.getObjectEncryptionType().equals(this.getObjectEncryptionType())) {
            return false;
        }
        if (other.getKmsKeyArn() == null ^ this.getKmsKeyArn() == null) {
            return false;
        }
        return other.getKmsKeyArn() == null || other.getKmsKeyArn().equals(this.getKmsKeyArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getObjectEncryptionType() == null ? 0 : this.getObjectEncryptionType().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyArn() == null ? 0 : this.getKmsKeyArn().hashCode());
        return hashCode;
    }

    public S3EncryptionConfiguration clone() {
        try {
            return (S3EncryptionConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3EncryptionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

