/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.quicksight.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.quicksight.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DateTimeParameterDeclaration JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DateTimeParameterDeclarationJsonUnmarshaller implements Unmarshaller<DateTimeParameterDeclaration, JsonUnmarshallerContext> {

    public DateTimeParameterDeclaration unmarshall(JsonUnmarshallerContext context) throws Exception {
        DateTimeParameterDeclaration dateTimeParameterDeclaration = new DateTimeParameterDeclaration();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    dateTimeParameterDeclaration.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DefaultValues", targetDepth)) {
                    context.nextToken();
                    dateTimeParameterDeclaration.setDefaultValues(DateTimeDefaultValuesJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("TimeGranularity", targetDepth)) {
                    context.nextToken();
                    dateTimeParameterDeclaration.setTimeGranularity(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ValueWhenUnset", targetDepth)) {
                    context.nextToken();
                    dateTimeParameterDeclaration.setValueWhenUnset(DateTimeValueWhenUnsetConfigurationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("MappedDataSetParameters", targetDepth)) {
                    context.nextToken();
                    dateTimeParameterDeclaration.setMappedDataSetParameters(new ListUnmarshaller<MappedDataSetParameter>(MappedDataSetParameterJsonUnmarshaller
                            .getInstance())

                    .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return dateTimeParameterDeclaration;
    }

    private static DateTimeParameterDeclarationJsonUnmarshaller instance;

    public static DateTimeParameterDeclarationJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new DateTimeParameterDeclarationJsonUnmarshaller();
        return instance;
    }
}
