/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.quicksight.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The configuration of a page break for a section.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SectionPageBreakConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SectionPageBreakConfiguration implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The configuration of a page break after a section.
     * </p>
     */
    private SectionAfterPageBreak after;

    /**
     * <p>
     * The configuration of a page break after a section.
     * </p>
     * 
     * @param after
     *        The configuration of a page break after a section.
     */

    public void setAfter(SectionAfterPageBreak after) {
        this.after = after;
    }

    /**
     * <p>
     * The configuration of a page break after a section.
     * </p>
     * 
     * @return The configuration of a page break after a section.
     */

    public SectionAfterPageBreak getAfter() {
        return this.after;
    }

    /**
     * <p>
     * The configuration of a page break after a section.
     * </p>
     * 
     * @param after
     *        The configuration of a page break after a section.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SectionPageBreakConfiguration withAfter(SectionAfterPageBreak after) {
        setAfter(after);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAfter() != null)
            sb.append("After: ").append(getAfter());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof SectionPageBreakConfiguration == false)
            return false;
        SectionPageBreakConfiguration other = (SectionPageBreakConfiguration) obj;
        if (other.getAfter() == null ^ this.getAfter() == null)
            return false;
        if (other.getAfter() != null && other.getAfter().equals(this.getAfter()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAfter() == null) ? 0 : getAfter().hashCode());
        return hashCode;
    }

    @Override
    public SectionPageBreakConfiguration clone() {
        try {
            return (SectionPageBreakConfiguration) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.quicksight.model.transform.SectionPageBreakConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
